/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.monitor;

import java.util.ArrayList;
import java.util.Iterator;

import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.ping.ejb.session.MonitorPingController;

/**
 * Ping監視情報の有効・無効を設定するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ChangeValidMonitorPing {

	// ログ出力
	private static Log log = LogFactory.getLog(ChangeValidMonitorPing.class);

	/**
	 * Ping監視情報の有効・無効を設定する<br>
	 * 
	 * @param valid 有効/無効
	 */
	@SuppressWarnings("unchecked")
	public void changeValid(boolean valid) {
		log.info(Messages.getMsg("Ping.Start", new String[]{Messages.getMsg("ImportTool.Change.Valid")}));

		//監視項目リスト取得
		ArrayList idList = getMonitorList();

		if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				ArrayList line = (ArrayList)itr.next();

				MonitorInfo info = getPing((String)line.get(0));
				info.setValid(ValidConstant.booleanToType(valid));
				changeMonitorInfo(info);
			}
		}

		log.info(Messages.getMsg("Ping.End", new String[]{Messages.getMsg("ImportTool.Change.Valid")}));
	}

	/**
	 * 監視情報の有効・無効を変更する。<br>
	 * 
	 * @param info 監視情報オブジェクト
	 */
	protected void changeMonitorInfo(MonitorInfo info) {
		MonitorPingController ping = EjbConnectionManager.getConnectionManager().getMonitorPingController();

		try {
			Object[] args = {info.getMonitorId()};
			log.info(Messages.getMsg("MonitorID", args) + 
					" (" + Messages.getMsg("modify") + ")");

			ping.modifyPing(info);
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
	}

	/**
	 * Ping監視情報を取得する。<br>
	 * 
	 * @param monitorId 取得対象の監視項目ID
	 * @return Ping監視情報
	 */
	protected MonitorInfo getPing(String monitorId) {

		MonitorPingController ping = EjbConnectionManager.getConnectionManager().getMonitorPingController();

		MonitorInfo info = null;
		try {
			info = ping.getPing(monitorId);
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return info;
	}

	/**
	 * 監視項目リストを取得する。<br>
	 * 
	 * @return 監視項目一覧
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList getMonitorList() {

		MonitorPingController ping = EjbConnectionManager.getConnectionManager().getMonitorPingController();

		ArrayList records = null;
		try {
			records = ping.getPingList();
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return records;
	}
}