/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.logtransfer;

import java.util.ArrayList;
import java.util.Iterator;

import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.logtransfer.ejb.session.LogTransferController;

/**
 * ログ転送情報を削除するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class DeleteLogTransfer {

	// ログ出力
	private static Log log = LogFactory.getLog(DeleteLogTransfer.class);

	/**
	 * ログ転送情報を削除する<br>
	 */
	@SuppressWarnings("unchecked")
	public void delete() {
		log.info(Messages.getMsg("LogTransfer.Start", new String[]{Messages.getMsg("ImportTool.Delete")}));

		//監視項目リスト取得
		ArrayList idList = getLogTransferList();

		if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				ArrayList line = (ArrayList)itr.next();

				deleteLogTransferInfo((String)line.get(0));
			}
		}

		log.info(Messages.getMsg("LogTransfer.End", new String[]{Messages.getMsg("ImportTool.Delete")}));
	}

	/**
	 * ログ転送情報を削除する。<br>
	 * 
	 * @param transferId ログ転送ID
	 */
	protected void deleteLogTransferInfo(String transferId) {

		LogTransferController transfer = EjbConnectionManager.getConnectionManager().getLogTransferController();

		try {
			Object[] args = {transferId};
			log.info(Messages.getMsg("TransferID", args) + 
					" (" + Messages.getMsg("delete") + ")");

			transfer.deleteLogTransfer(transferId);
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
	}

	/**
	 * 転送項目リストを取得する。<br>
	 * 
	 * @return 転送項目一覧
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList getLogTransferList() {

		LogTransferController transfer = EjbConnectionManager.getConnectionManager().getLogTransferController();

		ArrayList records = null;
		try {
			records = transfer.getLogTransferList();
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return records;
	}
}