/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.notify;

import java.util.ArrayList;
import java.util.Iterator;

import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.notify.mail.ejb.session.MailTemplateController;

/**
 * メールテンプレート情報を削除するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class DeleteMailTemplate {

	// ログ出力
	private static Log log = LogFactory.getLog(DeleteMailTemplate.class);

	/**
	 * メールテンプレート情報を削除する。<br>
	 */
	@SuppressWarnings("unchecked")
	public void delete() {
		log.info(Messages.getMsg("MailTemplate.Start", new String[]{Messages.getMsg("ImportTool.Delete")}));

		//メールテンプレートリスト取得
		ArrayList idList = getMailTemplateList();

		if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				ArrayList line = (ArrayList)itr.next();

				deleteMailTemplateInfo((String)line.get(0));
			}
		}
		log.info(Messages.getMsg("MailTemplate.End", new String[]{Messages.getMsg("ImportTool.Delete")}));
	}

	/**
	 * メールテンプレート情報を削除する。<br>
	 * 
	 * @param mailTemplateId メールテンプレートID
	 */
	protected void deleteMailTemplateInfo(String mailTemplateId) {

		MailTemplateController mail = EjbConnectionManager.getConnectionManager().getMailTemplateController();

		try {
			Object[] args = {mailTemplateId};
			log.info(Messages.getMsg("MailTemplateID", args) + 
					" (" + Messages.getMsg("delete") + ")");

			mail.deleteMailTemplate(mailTemplateId);
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
	}

	/**
	 * メールテンプレートリストを取得する。<br>
	 * 
	 * @return メールテンプレート一覧
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList getMailTemplateList() {

		MailTemplateController mail = EjbConnectionManager.getConnectionManager().getMailTemplateController();

		ArrayList records = null;
		try {
			records = mail.getMailTemplateList();
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return records;
	}
}