/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.monitor;

import java.util.ArrayList;

import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.syslogng.bean.LogFilterInfo;
import com.clustercontrol.syslogng.ejb.session.MonitorSyslogNGController;

/**
 * Syslog-ng監視情報の有効・無効を設定するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ChangeValidMonitorSyslogng {

	// ログ出力
	private static Log log = LogFactory.getLog(ChangeValidMonitorSyslogng.class);

	/**
	 * Syslog-ng監視情報の有効・無効を設定する<br>
	 * 
	 * @param valid 有効/無効
	 */
	@SuppressWarnings("unchecked")
	public void changeValid(boolean valid) {
		log.info(Messages.getMsg("Syslogng.Start", new String[]{Messages.getMsg("ImportTool.Change.Valid")}));

		//監視項目リスト取得
		ArrayList<LogFilterInfo> idList = getMonitorList();

		for(LogFilterInfo line : idList){
			Object[] args = {line.getMonitorId()};
			log.info(Messages.getMsg("MonitorID", args));

			line.setValid(ValidConstant.booleanToType(valid));
		}
		changeMonitorInfo(idList);


		log.info(Messages.getMsg("Syslogng.End", new String[]{Messages.getMsg("ImportTool.Change.Valid")}));
	}

	/**
	 * 監視情報を登録する。<br>
	 * 
	 * @param logFilterInfos 監視情報オブジェクト
	 */
	protected void changeMonitorInfo(ArrayList<LogFilterInfo> logFilterInfos) {
		MonitorSyslogNGController syslog = EjbConnectionManager.getConnectionManager().getMonitorSyslogNGController();

		try {
			syslog.createMonitorRuleList(logFilterInfos);
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
	}

	/**
	 * 監視項目リストを取得する。<br>
	 * 
	 * @return 監視項目一覧
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList<LogFilterInfo> getMonitorList() {

		MonitorSyslogNGController syslog = EjbConnectionManager.getConnectionManager().getMonitorSyslogNGController();

		ArrayList<LogFilterInfo> records = null;
		try {
			records = syslog.getFilterInfoList();
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return records;
	}
}