/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.monitor;

import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorNumericValueInfo;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;
import com.clustercontrol.sql.bean.MonitorSqlInfo;
import com.clustercontrol.sql.ejb.session.MonitorSqlController;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitorNumeric;
import jp.co.intellilink.hinemos.export.conf.monitor.JdbcDriverUtil;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportMonitorSql
extends ExportMonitorNumeric {
    private static Log log = LogFactory.getLog(ExportMonitorSql.class);

    public ExportMonitorSql() {
        super(0);
    }

    public void exportSql() {
        log.info((Object)Messages.getMsg("Sql.Start", new String[]{Messages.getMsg("ExportTool.Export")}));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getSnmpList();
        if (arrayList2 instanceof ArrayList) {
            for (Cloneable cloneable : arrayList2) {
                int n = MonitorTypeConstant.stringToType((String)((String)((ArrayList)cloneable).get(3)));
                if (n != 1) continue;
                Object[] objectArray = new Object[]{(String)((ArrayList)cloneable).get(0)};
                log.info((Object)Messages.getMsg("MonitorID", objectArray));
                MonitorInfo monitorInfo = this.getSnmp((String)((ArrayList)cloneable).get(0), n);
                arrayList.add(this.createCsvFormat(monitorInfo));
            }
            Collections.sort(arrayList, new StringListComparator(0));
        }
        Object object = "";
        if (Config.getConfig("file.timestamp").equalsIgnoreCase("on")) {
            Cloneable cloneable;
            cloneable = new SimpleDateFormat("yyyyMMdd_HHmmss");
            object = "_" + ((DateFormat)cloneable).format(new Date());
        }
        WriteCsvFile.writeCsvFile(Config.getConfig("Export.Dir") + "/SQL" + (String)object + ".csv", arrayList);
        log.info((Object)Messages.getMsg("Sql.End", new String[]{Messages.getMsg("ExportTool.Export")}));
    }

    @Override
    public ArrayList<String> createCsvFormat(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.createMonitorBase(monitorInfo));
        arrayList.addAll(this.createMonitorRule(monitorInfo));
        arrayList.addAll(this.createMonitorInfo(monitorInfo));
        arrayList.addAll(this.createMonitorJudgement(monitorInfo));
        arrayList.addAll(this.createMonitorNotify(monitorInfo));
        if (monitorInfo.getApplication() != null) {
            arrayList.add(monitorInfo.getApplication());
        } else {
            arrayList.add("");
        }
        arrayList.addAll(this.createMonitorMessage(monitorInfo));
        arrayList.add(ValidConstant.typeToString((int)monitorInfo.getValid()));
        return arrayList;
    }

    @Override
    public ArrayList<String> createMonitorInfo(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        MonitorSqlInfo monitorSqlInfo = (MonitorSqlInfo)monitorInfo.getCheckInfo();
        if (monitorSqlInfo == null) {
            monitorSqlInfo = new MonitorSqlInfo();
        }
        if (monitorSqlInfo.getConnectionUrl() != null) {
            arrayList.add(monitorSqlInfo.getConnectionUrl());
        } else {
            arrayList.add("");
        }
        if (monitorSqlInfo.getJdbcDriver() != null) {
            List<List<String>> list = JdbcDriverUtil.getJdbcDriver();
            for (int i = 0; i < list.size(); ++i) {
                List<String> list2 = list.get(i);
                String string = list2.get(1);
                if (!string.equals(monitorSqlInfo.getJdbcDriver())) continue;
                arrayList.add(list2.get(0));
                break;
            }
        } else {
            arrayList.add("");
        }
        if (monitorSqlInfo.getUser() != null) {
            arrayList.add(monitorSqlInfo.getUser().toString());
        } else {
            arrayList.add("");
        }
        if (monitorSqlInfo.getPassword() != null) {
            arrayList.add(monitorSqlInfo.getPassword());
        } else {
            arrayList.add("");
        }
        if (monitorSqlInfo.getQuery() != null) {
            arrayList.add(monitorSqlInfo.getQuery());
        } else {
            arrayList.add("");
        }
        return arrayList;
    }

    protected ArrayList<String> createMonitorMessage(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        for (int i = 0; i < 2; ++i) {
            arrayList2.add("");
            arrayList3.add("");
            arrayList4.add("");
        }
        ArrayList arrayList5 = monitorInfo.getJudgementInfo();
        if (arrayList5 != null) {
            for (int i = 0; i < arrayList5.size(); ++i) {
                MonitorNumericValueInfo monitorNumericValueInfo = (MonitorNumericValueInfo)arrayList5.get(i);
                if (monitorNumericValueInfo == null) continue;
                ArrayList<String> arrayList6 = null;
                if (3 == monitorNumericValueInfo.getPriority()) {
                    arrayList6 = arrayList2;
                } else if (2 == monitorNumericValueInfo.getPriority()) {
                    arrayList6 = arrayList3;
                } else {
                    if (0 != monitorNumericValueInfo.getPriority()) continue;
                    arrayList6 = arrayList4;
                }
                if (monitorNumericValueInfo.getMessageId() != null) {
                    arrayList6.set(0, monitorNumericValueInfo.getMessageId());
                }
                if (monitorNumericValueInfo.getMessage() == null) continue;
                arrayList6.set(1, monitorNumericValueInfo.getMessage());
            }
        }
        arrayList.addAll(arrayList2);
        arrayList.addAll(arrayList3);
        arrayList.addAll(arrayList4);
        return arrayList;
    }

    protected MonitorInfo getSnmp(String string, int n) {
        MonitorSqlController monitorSqlController = EjbConnectionManager.getConnectionManager().getMonitorSqlController();
        MonitorInfo monitorInfo = null;
        try {
            monitorInfo = monitorSqlController.getSqlInfo(string, n);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return monitorInfo;
    }

    protected ArrayList getSnmpList() {
        MonitorSqlController monitorSqlController = EjbConnectionManager.getConnectionManager().getMonitorSqlController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorSqlController.getSqlList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

