/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.monitor;

import com.clustercontrol.bean.PingRunCountConstant;
import com.clustercontrol.bean.PingRunIntervalConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.ping.bean.PingCheckInfo;
import com.clustercontrol.ping.ejb.session.MonitorPingController;
import java.util.ArrayList;
import java.util.List;
import jp.co.intellilink.hinemos.importtool.conf.monitor.ImportMonitorNumeric;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.ReadCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportMonitorPing
extends ImportMonitorNumeric {
    private static Log log = LogFactory.getLog(ImportMonitorPing.class);
    private ArrayList monitorList = null;
    private ArrayList<ArrayList<String>> monitorInfos = null;

    public void importPing() {
        log.info((Object)Messages.getMsg("Ping.Start", new String[]{Messages.getMsg("ImportTool.Import")}));
        this.monitorInfos = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/PING.csv");
        this.monitorList = this.getMonitorList();
        for (ArrayList<String> arrayList : this.monitorInfos) {
            MonitorInfo monitorInfo = this.createMonitorInfo(arrayList);
            this.registerMonitorInfo(monitorInfo);
        }
        log.info((Object)Messages.getMsg("Ping.End", new String[]{Messages.getMsg("ImportTool.Import")}));
    }

    @Override
    protected MonitorInfo createMonitorInfo(ArrayList<String> arrayList) {
        MonitorInfo monitorInfo = new MonitorInfo();
        this.createMonitorBase(arrayList, monitorInfo);
        this.createMonitorRule(arrayList.subList(3, 5), monitorInfo);
        this.createMonitorCheck(arrayList.subList(5, 8), monitorInfo);
        this.createMonitorBlock(arrayList.subList(8, 9), monitorInfo);
        this.createMonitorJudgement(arrayList.subList(9, 14), monitorInfo);
        this.createMonitorNotify(arrayList.subList(14, 20), monitorInfo);
        this.createMonitorApplication(arrayList.subList(20, 21), monitorInfo);
        this.createMonitorVaild(arrayList.subList(21, 22), monitorInfo);
        return monitorInfo;
    }

    @Override
    protected void createMonitorCheck(List<String> list, MonitorInfo monitorInfo) {
        PingCheckInfo pingCheckInfo = new PingCheckInfo();
        pingCheckInfo.setRunCount(Integer.valueOf(PingRunCountConstant.stringToType((String)list.get(0))));
        pingCheckInfo.setRunInterval(Integer.valueOf(PingRunIntervalConstant.stringToType((String)list.get(1))));
        pingCheckInfo.setTimeout(Integer.valueOf(Integer.parseInt(list.get(2))));
        monitorInfo.setPingCheckInfo(pingCheckInfo);
        monitorInfo.setMonitorType(1);
        super.createMonitorCheck(list, monitorInfo);
    }

    protected void registerMonitorInfo(MonitorInfo monitorInfo) {
        MonitorPingController monitorPingController = EjbConnectionManager.getConnectionManager().getMonitorPingController();
        try {
            MonitorInfo monitorInfo2 = this.checkMonitorList(monitorInfo.getMonitorId(), this.monitorList);
            if (monitorInfo2 instanceof MonitorInfo) {
                monitorInfo.setRegDate(monitorInfo2.getRegDate());
                monitorInfo.setRegUser(monitorInfo2.getRegUser());
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("MonitorID", objectArray) + " (" + Messages.getMsg("modify") + ")"));
                monitorPingController.modifyPing(monitorInfo);
            } else {
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("MonitorID", objectArray) + " (" + Messages.getMsg("add") + ")"));
                monitorPingController.addPing(monitorInfo);
            }
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected ArrayList getMonitorList() {
        MonitorPingController monitorPingController = EjbConnectionManager.getConnectionManager().getMonitorPingController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorPingController.getPingList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

