/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.monitor;

import com.clustercontrol.bean.PingRunCountConstant;
import com.clustercontrol.bean.PingRunIntervalConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.ping.bean.PingCheckInfo;
import com.clustercontrol.ping.ejb.session.MonitorPingController;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitorNumeric;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportMonitorPing
extends ExportMonitorNumeric {
    private static Log log = LogFactory.getLog(ExportMonitorPing.class);

    public ExportMonitorPing() {
        super(3, 2);
    }

    public void exportPing() {
        log.info((Object)Messages.getMsg("Ping.Start", new String[]{Messages.getMsg("ExportTool.Export")}));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getPingList();
        if (arrayList2 instanceof ArrayList) {
            for (Object object2 : arrayList2) {
                Object[] objectArray = new Object[]{object2.getMonitorId()};
                log.info((Object)Messages.getMsg("MonitorID", objectArray));
                arrayList.add(this.createCsvFormat((MonitorInfo)object2));
            }
            Collections.sort(arrayList, new StringListComparator(0));
        }
        Object object = "";
        if (Config.getConfig("file.timestamp").equalsIgnoreCase("on")) {
            Object object2;
            object2 = new SimpleDateFormat("yyyyMMdd_HHmmss");
            object = "_" + ((DateFormat)object2).format(new Date());
        }
        WriteCsvFile.writeCsvFile(Config.getConfig("Export.Dir") + "/PING" + (String)object + ".csv", arrayList);
        log.info((Object)Messages.getMsg("Ping.End", new String[]{Messages.getMsg("ExportTool.Export")}));
    }

    @Override
    public ArrayList<String> createMonitorInfo(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        PingCheckInfo pingCheckInfo = monitorInfo.getPingCheckInfo();
        if (pingCheckInfo == null) {
            pingCheckInfo = new PingCheckInfo();
        }
        if (pingCheckInfo.getRunCount() != null) {
            arrayList.add(PingRunCountConstant.typeToString((int)pingCheckInfo.getRunCount()));
        } else {
            arrayList.add("");
        }
        if (pingCheckInfo.getRunInterval() != null) {
            arrayList.add(PingRunIntervalConstant.typeToString((int)pingCheckInfo.getRunInterval()));
        } else {
            arrayList.add("");
        }
        if (pingCheckInfo.getTimeout() != null) {
            arrayList.add(pingCheckInfo.getTimeout().toString());
        } else {
            arrayList.add("");
        }
        return arrayList;
    }

    protected ArrayList getPingList() {
        MonitorPingController monitorPingController = EjbConnectionManager.getConnectionManager().getMonitorPingController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorPingController.getPingList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

