/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.monitor;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.http.bean.HttpCheckInfo;
import com.clustercontrol.http.ejb.session.MonitorHttpController;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import java.util.ArrayList;
import java.util.List;
import jp.co.intellilink.hinemos.importtool.conf.monitor.ImportMonitorString;
import jp.co.intellilink.hinemos.util.CheckString;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.ReadCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportMonitorHttpString
extends ImportMonitorString {
    private static Log log = LogFactory.getLog(ImportMonitorHttpString.class);
    private ArrayList monitorList = null;
    private ArrayList<ArrayList<String>> monitorInfos = null;

    public void importHttp() {
        log.info((Object)Messages.getMsg("Http.Start", new String[]{Messages.getMsg("ImportTool.Import")}));
        this.monitorInfos = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/HTTP_STR.csv");
        this.monitorRuleInfos = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/HTTP_STR_RULE.csv");
        this.monitorList = this.getMonitorList();
        for (ArrayList<String> arrayList : this.monitorInfos) {
            MonitorInfo monitorInfo = this.createMonitorInfo(arrayList);
            this.registerMonitorInfo(monitorInfo);
        }
        log.info((Object)Messages.getMsg("Http.End", new String[]{Messages.getMsg("ImportTool.Import")}));
    }

    @Override
    protected MonitorInfo createMonitorInfo(ArrayList<String> arrayList) {
        MonitorInfo monitorInfo = new MonitorInfo();
        this.createMonitorBase(arrayList, monitorInfo);
        this.createMonitorRule(arrayList.subList(3, 5), monitorInfo);
        this.createMonitorCheck(arrayList.subList(5, 7), monitorInfo);
        this.createMonitorNotify(arrayList.subList(7, 13), monitorInfo);
        this.createMonitorApplication(arrayList.subList(13, 14), monitorInfo);
        if (arrayList.get(14) instanceof String && arrayList.get(14).length() > 0) {
            monitorInfo.setFailurePriority(PriorityConstant.stringToType((String)arrayList.get(13)));
        }
        this.createMonitorVaild(arrayList.subList(15, 16), monitorInfo);
        this.createMonitorJudgement(monitorInfo);
        return monitorInfo;
    }

    @Override
    protected void createMonitorCheck(List<String> list, MonitorInfo monitorInfo) {
        HttpCheckInfo httpCheckInfo = new HttpCheckInfo();
        String string = CheckString.checkLength(list.get(0), 2083);
        if (!string.equals(list.get(0))) {
            Object[] objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"request.url"), "2083"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
        }
        httpCheckInfo.setRequestUrl(string);
        httpCheckInfo.setTimeout(Integer.parseInt(list.get(1)));
        monitorInfo.setHttpCheckInfo(httpCheckInfo);
        monitorInfo.setMonitorType(2);
        super.createMonitorCheck(list, monitorInfo);
    }

    protected void registerMonitorInfo(MonitorInfo monitorInfo) {
        MonitorHttpController monitorHttpController = EjbConnectionManager.getConnectionManager().getMonitorHttpController();
        try {
            MonitorInfo monitorInfo2 = this.checkMonitorList(monitorInfo.getMonitorId(), this.monitorList);
            if (monitorInfo2 instanceof MonitorInfo) {
                monitorInfo.setRegDate(monitorInfo2.getRegDate());
                monitorInfo.setRegUser(monitorInfo2.getRegUser());
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("MonitorID", objectArray) + " (" + Messages.getMsg("modify") + ")"));
                monitorHttpController.modifyHttp(monitorInfo);
            } else {
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("MonitorID", objectArray) + " (" + Messages.getMsg("add") + ")"));
                monitorHttpController.addHttp(monitorInfo);
            }
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected ArrayList getMonitorList() {
        MonitorHttpController monitorHttpController = EjbConnectionManager.getConnectionManager().getMonitorHttpController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorHttpController.getHttpList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

