/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.check.conf;

import java.util.ArrayList;
import java.util.Iterator;

import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.ping.ejb.session.MonitorPingController;

/**
 * Ping監視情報を取得するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class CheckMonitorPing extends CheckMonitor {

	// ログ出力
	private static Log log = LogFactory.getLog(CheckMonitorPing.class);

	/**
	 * Ping監視の監視項目数、ノード数、通知数を取得する。<br>
	 */
	@SuppressWarnings("unchecked")
	public ArrayList<String> checkPing() {
		log.info(Messages.getMsg("Ping.Start", new String[]{""}));

		//監視項目リスト取得
		ArrayList idList = getPingList();
		setIdList(idList);

		if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				ArrayList line = (ArrayList)itr.next();

				Object[] args = {(String)line.get(0)};
				log.info(Messages.getMsg("MonitorID", args));

				MonitorInfo info = getPing((String)line.get(0));
				int nodeCount = getNodeCount(info);
				int notifyCount = getNotifyCount(info);

				addNodeTotalCount(nodeCount);
				addNotifyTotalCount(nodeCount * notifyCount);
			}
		}

		log.info(Messages.getMsg("Ping.End", new String[]{""}));

		return createOutput("Ping");
	}

	/**
	 * Ping監視情報を取得する。<br>
	 * 
	 * @param monitorId 取得対象の監視項目ID
	 * @return Ping監視情報
	 */
	protected MonitorInfo getPing(String monitorId) {

		MonitorPingController ping = EjbConnectionManager.getConnectionManager().getMonitorPingController();

		MonitorInfo info = null;
		try {
			info = ping.getPing(monitorId);
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return info;
	}

	/**
	 * 監視項目リストを取得する。<br>
	 * 
	 * @return 監視項目一覧
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList getPingList() {

		MonitorPingController ping = EjbConnectionManager.getConnectionManager().getMonitorPingController();

		ArrayList records = null;
		try {
			records = ping.getPingList();
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return records;
	}
}