/*
 
Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.hinemos.export.conf.repository;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;

import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.repository.bean.FacilityInfo;
import com.clustercontrol.repository.bean.NodeInfo;
import com.clustercontrol.repository.ejb.session.RepositoryController;

/**
 * スコープへのノード割り当て情報を取得するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ExportNodeScope {
	
	// ログ出力
	private static Log log = LogFactory.getLog(ExportNodeScope.class);

    /**
     * スコープへのノード割り当て情報をExportする。<br>
     */
    public void exportNodeScope() {
    	log.info(Messages.getMsg("NodeScope.Start", new String[]{Messages.getMsg("ExportTool.Export")}));
    	
    	//CSV出力配列を用意
    	ArrayList<ArrayList<String>> csvOutput = new ArrayList<ArrayList<String>>();
    	
    	//ファシリティツリー取得
    	FacilityTreeItem facilityTree = getFacilityTree();
    	getFacilityTreeItem(facilityTree, csvOutput);
		
		//ファシリティIDでソート
		Collections.sort(csvOutput, new StringListComparator(1));
		Collections.sort(csvOutput, new StringListComparator(0));
		
		String timestamp = "";
		if(Config.getConfig("file.timestamp").equalsIgnoreCase("on")){
			SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HHmmss");
			timestamp = "_" + format.format(new Date());
		}
		WriteCsvFile.writeCsvFile(
				Config.getConfig("Export.Dir") + "/NODE_SCOPE" + timestamp + ".csv", 
				csvOutput);
		
		log.info(Messages.getMsg("NodeScope.End", new String[]{Messages.getMsg("ExportTool.Export")}));
    }
    
    /**
     * スコープへのノード割り当て情報取得（再帰呼び出し）
     * 
     * @param treeItem
     * @param csvOutput CSV出力文字列配列
     */
    public void getFacilityTreeItem(FacilityTreeItem treeItem, ArrayList<ArrayList<String>> csvOutput) {

        //子ツリーを取得する
        if (treeItem.getData() instanceof FacilityInfo){
        	FacilityInfo info = treeItem.getData();
        	if(info.getFacilityType() == FacilityConstant.TYPE_NODE 
        			&& info.getFacilityId() != null 
        			&& info.getFacilityId().compareTo("") != 0){
        		
    			Object[] args = {info.getFacilityId()};
    			log.info(Messages.getMsg("FacilityID", args));
        		
    			NodeInfo node = getNode(info.getFacilityId());
    			ArrayList<String> csvFormat = createCsvFormat(node);
            	String parentFacilityId = "";
    			 if(treeItem.getParent() != null){
            		if (treeItem.getParent().getData() instanceof FacilityInfo){
            			FacilityInfo parentInfo = treeItem.getParent().getData();
            			if(parentInfo.getFacilityId() != null && parentInfo.getFacilityId().compareTo("") != 0){
            				parentFacilityId = parentInfo.getFacilityId();
            			}
            		}
            	}
    			csvFormat.add(0, parentFacilityId);
    			csvOutput.add(csvFormat);
        	}
        }
        
        
    	FacilityTreeItem[] childrenTreeItem = treeItem.getChildren();
        for (FacilityTreeItem childTreeItem : childrenTreeItem) {
        	getFacilityTreeItem(childTreeItem, csvOutput);
        }
    }
    
    /**
	 * スコープへのノード割り当て情報をExportする。<br>
	 * 
	 * @param info ノード情報
	 * @return CSVフォーマット文字列
	 */
	public ArrayList<String> createCsvFormat(NodeInfo info) {
		ArrayList<String> csvFormat = new ArrayList<String>();
		
		//ファシリティID
		csvFormat.add(getStringValue(info.getFacilityId()));
		//ファシリティ名
		csvFormat.add(getStringValue(info.getFacilityName()));
		
		return csvFormat;
	}
	
	/**
	 * 文字列を取得する。<br>
	 * 
	 * @param values 配列
	 * @return 文字列
	 */
	public String getStringValue(String values) {
		return values;
	}
	
    /**
     * ノード情報を取得する。<br>
     * 
     * @param facilityId 取得対象のファシリティID
     * @return ノード情報
     */
    protected NodeInfo getNode(String facilityId) {

    	RepositoryController repository = EjbConnectionManager.getConnectionManager().getRepositoryController();

    	NodeInfo info = null;
        try {
        	info = repository.getNode(facilityId);
        } catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
        }
        return info;
    }
    
    /**
     * ファシリティツリーを取得する。<br>
     * 
     * @return ファシリティツリー
     */
    protected FacilityTreeItem getFacilityTree() {

    	RepositoryController repository = EjbConnectionManager.getConnectionManager().getRepositoryController();

    	FacilityTreeItem facilityTree = null;
        try {
        	facilityTree = repository.getFacilityTree(Locale.getDefault());
        } catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
        return facilityTree;
    }
}