/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.maintenance;

import java.util.ArrayList;
import java.util.Iterator;

import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.Schedule;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.maintenance.bean.MaintenanceInfoDataImp;
import com.clustercontrol.maintenance.bean.ScheduleInfo;
import com.clustercontrol.maintenance.bean.ScheduleTableDefine;
import com.clustercontrol.maintenance.ejb.session.MaintenanceController;

/**
 * メンテナンス機能情報の有効・無効を設定するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ChangeValidMaintenance {

	// ログ出力
	private static Log log = LogFactory.getLog(ChangeValidMaintenance.class);

	/**
	 * メンテナンス監視情報の有効・無効を設定する<br>
	 * 
	 * @param valid 有効/無効
	 */
	@SuppressWarnings("unchecked")
	public void changeValid(boolean valid) {
		log.info(Messages.getMsg("Maintenance.Start", new String[]{Messages.getMsg("ImportTool.Change.Valid")}));

		//監視項目リスト取得
		ArrayList idList = getMaintenanceList();

		if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				ArrayList line = (ArrayList)itr.next();

				MaintenanceInfoDataImp info = getMaintenance((String)line.get(0));
				ArrayList scheduleList = getSchedule((String)line.get(0));
				
				info.setValid_flg(ValidConstant.booleanToType(valid));
				ScheduleInfo scheduleInfo = createScheduleInfo(info, (Schedule)scheduleList.get(ScheduleTableDefine.SCHEDULE));

				changeMaintenanceInfo(info, scheduleInfo);
			}
		}

		log.info(Messages.getMsg("Maintenance.End", new String[]{Messages.getMsg("ImportTool.Change.Valid")}));
	}

	/**
	 * スケジュール情報を作成する。<br>
	 * 
	 * @param info メンテナンス情報配列
	 * @return スケジュール情報
	 */
	public ScheduleInfo createScheduleInfo(MaintenanceInfoDataImp info, Schedule schedule) {
		ScheduleInfo scheduleInfo = new ScheduleInfo();

		//メンテナンスID
		scheduleInfo.setId(info.getMaintenance_id());
		scheduleInfo.setJobId(info.getMaintenance_id());
		//説明
		scheduleInfo.setName(info.getDescription());
		scheduleInfo.setJobName(info.getDescription());
		//カレンダID
		scheduleInfo.setCalendarId(info.getCalendar_id());
		//スケジュール
		scheduleInfo.setSchedule(schedule);
		//有効/無効
		scheduleInfo.setValid(info.getValid_flg());

		return scheduleInfo;
	}

	/**
	 * メンテナンス情報の有効・無効を変更する。<br>
	 * 
	 * @param maintenanceInfo メンテナンス情報
	 * @param scheduleInfo スケジュール情報
	 */
	protected void changeMaintenanceInfo(MaintenanceInfoDataImp maintenanceInfo, 
			ScheduleInfo scheduleInfo) {

		MaintenanceController maintenance = EjbConnectionManager.getConnectionManager().getMaintenanceController();

		try {
			Object[] args = {maintenanceInfo.getMaintenance_id()};
			log.info(Messages.getMsg("MaintenanceID", args) + 
					" (" + Messages.getMsg("modify") + ")");

			maintenance.modifyMaintenance(maintenanceInfo, scheduleInfo);
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
	}

	/**
	 * メンテナンス情報を取得する。<br>
	 * 
	 * @param maintenanceId 取得対象のメンテナンスID
	 * @return メンテナンス情報
	 */
	protected MaintenanceInfoDataImp getMaintenance(String maintenanceId) {

		MaintenanceController maintenance = EjbConnectionManager.getConnectionManager().getMaintenanceController();

		MaintenanceInfoDataImp info = null;
		try {
			info = maintenance.getMaintenanceInfo(maintenanceId);
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return info;
	}

	/**
	 * スケジュール情報を取得する。<br>
	 * 
	 * @param maintenanceId 取得対象のメンテナンスID
	 * @return スケジュール情報
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList getSchedule(String maintenanceId) {

		MaintenanceController maintenance = EjbConnectionManager.getConnectionManager().getMaintenanceController();

		ArrayList info = null;
		try {
			info = maintenance.getSchedule(maintenanceId);
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return info;
	}

	/**
	 * メンテナンスリストを取得する。<br>
	 * 
	 * @return メンテナンス一覧
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList getMaintenanceList() {

		MaintenanceController maintenance = EjbConnectionManager.getConnectionManager().getMaintenanceController();

		ArrayList records = null;
		try {
			records = maintenance.getMaintenanceList();
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return records;
	}
}