/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.monitor;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.process.bean.ProcessCheckInfo;
import com.clustercontrol.process.ejb.session.MonitorProcessController;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitorNumeric;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportMonitorProcess
extends ExportMonitorNumeric {
    private static Log log = LogFactory.getLog(ExportMonitorProcess.class);

    public ExportMonitorProcess() {
        super(2);
    }

    public void exportProcess() {
        log.info((Object)Messages.getMsg("Process.Start", new String[]{Messages.getMsg("ExportTool.Export")}));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getProcessList();
        if (arrayList2 instanceof ArrayList) {
            for (Object object2 : arrayList2) {
                Object[] objectArray = new Object[]{object2.getMonitorId()};
                log.info((Object)Messages.getMsg("MonitorID", objectArray));
                arrayList.add(this.createCsvFormat((MonitorInfo)object2));
            }
            Collections.sort(arrayList, new StringListComparator(0));
        }
        Object object = "";
        if (Config.getConfig("file.timestamp").equalsIgnoreCase("on")) {
            Object object2;
            object2 = new SimpleDateFormat("yyyyMMdd_HHmmss");
            object = "_" + ((DateFormat)object2).format(new Date());
        }
        WriteCsvFile.writeCsvFile(Config.getConfig("Export.Dir") + "/PROCESS" + (String)object + ".csv", arrayList);
        log.info((Object)Messages.getMsg("Process.End", new String[]{Messages.getMsg("ExportTool.Export")}));
    }

    @Override
    public ArrayList<String> createMonitorInfo(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ProcessCheckInfo processCheckInfo = monitorInfo.getProcessCheckInfo();
        if (processCheckInfo == null) {
            processCheckInfo = new ProcessCheckInfo();
        }
        if (processCheckInfo.getCommand() != null) {
            arrayList.add(processCheckInfo.getCommand());
        } else {
            arrayList.add("");
        }
        if (processCheckInfo.getParam() != null) {
            arrayList.add(processCheckInfo.getParam());
        } else {
            arrayList.add("");
        }
        return arrayList;
    }

    protected ArrayList getProcessList() {
        MonitorProcessController monitorProcessController = EjbConnectionManager.getConnectionManager().getMonitorProcessController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorProcessController.getProcessList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

