/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.monitor;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.snmp.bean.SnmpCheckInfo;
import com.clustercontrol.snmp.ejb.session.MonitorSnmpController;
import java.util.ArrayList;
import java.util.List;
import jp.co.intellilink.hinemos.importtool.conf.monitor.ImportMonitorString;
import jp.co.intellilink.hinemos.util.CheckString;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.ReadCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportMonitorSnmpString
extends ImportMonitorString {
    private static Log log = LogFactory.getLog(ImportMonitorSnmpString.class);
    private ArrayList monitorList = null;
    private ArrayList<ArrayList<String>> monitorInfos = null;

    public void importSnmp() {
        log.info((Object)Messages.getMsg("Snmp.Start", new String[]{Messages.getMsg("ImportTool.Import")}));
        this.monitorInfos = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/SNMP_STR.csv");
        this.monitorRuleInfos = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/SNMP_STR_RULE.csv");
        this.monitorList = this.getMonitorList();
        for (ArrayList<String> arrayList : this.monitorInfos) {
            MonitorInfo monitorInfo = this.createMonitorInfo(arrayList);
            this.registerMonitorInfo(monitorInfo);
        }
        log.info((Object)Messages.getMsg("Snmp.End", new String[]{Messages.getMsg("ImportTool.Import")}));
    }

    @Override
    protected MonitorInfo createMonitorInfo(ArrayList<String> arrayList) {
        MonitorInfo monitorInfo = new MonitorInfo();
        this.createMonitorBase(arrayList, monitorInfo);
        this.createMonitorRule(arrayList.subList(3, 5), monitorInfo);
        this.createMonitorCheck(arrayList.subList(5, 9), monitorInfo);
        this.createMonitorNotify(arrayList.subList(9, 15), monitorInfo);
        this.createMonitorApplication(arrayList.subList(15, 16), monitorInfo);
        if (arrayList.get(16) instanceof String && arrayList.get(16).length() > 0) {
            monitorInfo.setFailurePriority(PriorityConstant.stringToType((String)arrayList.get(15)));
        }
        this.createMonitorVaild(arrayList.subList(17, 18), monitorInfo);
        this.createMonitorJudgement(monitorInfo);
        return monitorInfo;
    }

    @Override
    protected void createMonitorCheck(List<String> list, MonitorInfo monitorInfo) {
        Object object;
        SnmpCheckInfo snmpCheckInfo = new SnmpCheckInfo();
        String string = CheckString.checkLength(list.get(0), 64);
        if (!string.equals(list.get(0))) {
            object = new String[]{com.clustercontrol.util.Messages.getString((String)"community.name"), "64"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", (Object[])object));
        }
        snmpCheckInfo.setCommunityName(string);
        snmpCheckInfo.setSnmpPort(Integer.valueOf(Integer.parseInt(list.get(1))));
        object = CheckString.checkLength(list.get(2), 1024);
        if (!((String)object).equals(list.get(2))) {
            Object[] objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"oid"), "1024"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
        }
        snmpCheckInfo.setSnmpOid((String)object);
        snmpCheckInfo.setSnmpVersion(list.get(3));
        monitorInfo.setSnmpCheckInfo(snmpCheckInfo);
        monitorInfo.setMonitorType(2);
        super.createMonitorCheck(list, monitorInfo);
    }

    protected void registerMonitorInfo(MonitorInfo monitorInfo) {
        MonitorSnmpController monitorSnmpController = EjbConnectionManager.getConnectionManager().getMonitorSnmpController();
        try {
            MonitorInfo monitorInfo2 = this.checkMonitorList(monitorInfo.getMonitorId(), this.monitorList);
            if (monitorInfo2 instanceof MonitorInfo) {
                monitorInfo.setRegDate(monitorInfo2.getRegDate());
                monitorInfo.setRegUser(monitorInfo2.getRegUser());
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("MonitorID", objectArray) + " (" + Messages.getMsg("modify") + ")"));
                monitorSnmpController.modifySnmp(monitorInfo);
            } else {
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("MonitorID", objectArray) + " (" + Messages.getMsg("add") + ")"));
                monitorSnmpController.addSnmp(monitorInfo);
            }
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected ArrayList getMonitorList() {
        MonitorSnmpController monitorSnmpController = EjbConnectionManager.getConnectionManager().getMonitorSnmpController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorSnmpController.getSnmpList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

