/*
 
Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.hinemos.export.conf.monitor;

import java.util.ArrayList;
import java.util.Collection;

import com.clustercontrol.bean.MonitorBlockConstant;
import com.clustercontrol.bean.RunIntervalConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.notify.bean.NotifyRelationInfo;
import com.clustercontrol.notify.bean.NotifyTypeConstant;

/**
 * 監視情報を取得するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ExportMonitor {

    /**
	 * 監視情報をExportする。<br>
	 * 
	 * @param monitorInfo 監視情報
	 * @return CSVフォーマット文字列
	 */
	public ArrayList<String> createCsvFormat(MonitorInfo monitorInfo) {
		ArrayList<String> csvFormat = new ArrayList<String>();
		
		return csvFormat;
	}
	
    /**
	 * 監視基本情報をExportする。<br>
	 * 
	 * @param monitorInfo 監視情報
	 * @return CSVフォーマット文字列
	 */
	protected ArrayList<String> createMonitorBase(MonitorInfo monitorInfo) {
		ArrayList<String> csvFormat = new ArrayList<String>();
		
		//監視項目ID
		csvFormat.add(monitorInfo.getMonitorId());
		//説明
		if (monitorInfo.getDescription() != null)
			csvFormat.add(monitorInfo.getDescription());
		else
			csvFormat.add("");
		//ファシリティID
		csvFormat.add(monitorInfo.getFacilityId());

		return csvFormat;
	}

    /**
	 * 監視単位情報をExportする。<br>
	 * 
	 * @param monitorInfo 監視情報
	 * @return CSVフォーマット文字列
	 */
	protected ArrayList<String> createMonitorBlock(MonitorInfo monitorInfo) {
		ArrayList<String> csvFormat = new ArrayList<String>();
		
        //単位
		if(monitorInfo.getMonitorBlock() == MonitorBlockConstant.TYPE_SCOPE)
			csvFormat.add(com.clustercontrol.util.Messages.getString("scope"));
		else
			csvFormat.add(com.clustercontrol.util.Messages.getString("node"));
		
		return csvFormat;
	}
	
    /**
	 * 監視条件情報をExportする。<br>
	 * 
	 * @param monitorInfo 監視情報
	 * @return CSVフォーマット文字列
	 */
	protected ArrayList<String> createMonitorRule(MonitorInfo monitorInfo) {
		ArrayList<String> csvFormat = new ArrayList<String>();

		//間隔
		csvFormat.add(RunIntervalConstant.typeToString(monitorInfo.getRunInterval()));
		//カレンダID
		if (monitorInfo.getCalendarId() != null)
			csvFormat.add(monitorInfo.getCalendarId());
		else
			csvFormat.add("");
		
		return csvFormat;
	}
	
    /**
	 * 監視情報をExportする。<br>
	 * 
	 * @param monitorInfo 監視情報
	 * @return CSVフォーマット文字列
	 */
	public ArrayList<String> createMonitorInfo(MonitorInfo monitorInfo){
		ArrayList<String> csvFormat = new ArrayList<String>();
		
		return csvFormat;
	}
	
	/**
     * 監視通知情報をExportする。<br>
     * 
     * @param monitorInfo 監視情報
     * @return CSVフォーマット文字列
     */
	protected ArrayList<String> createMonitorNotify(MonitorInfo monitorInfo) {
		ArrayList<String> csvFormat = new ArrayList<String>();
		
		String status = "";
		String event = "";
		String mail = "";
		String job = "";
		String syslog = "";
		String command = "";
		
		if(monitorInfo.getNotifyId() != null){
			Collection<NotifyRelationInfo> notify = monitorInfo.getNotifyId();
			
			NotifyRelationInfo relationInfo;
			for (int i = 0; i < notify.size(); i++) {
				relationInfo = (NotifyRelationInfo)((ArrayList<NotifyRelationInfo>)notify).get(i);
				if(relationInfo.getNotifyType() == NotifyTypeConstant.TYPE_STATUS)
					status = relationInfo.getNotifyId();
				else if(relationInfo.getNotifyType() == NotifyTypeConstant.TYPE_EVENT)
					event = relationInfo.getNotifyId();
				else if(relationInfo.getNotifyType() == NotifyTypeConstant.TYPE_MAIL)
					mail = relationInfo.getNotifyId();
				else if(relationInfo.getNotifyType() == NotifyTypeConstant.TYPE_JOB)
					job = relationInfo.getNotifyId();
				else if(relationInfo.getNotifyType() == NotifyTypeConstant.TYPE_LOG_ESCALATE)
					syslog = relationInfo.getNotifyId();
				else if(relationInfo.getNotifyType() == NotifyTypeConstant.TYPE_COMMAND)
					syslog = relationInfo.getNotifyId();
			}
		}

		csvFormat.add(status);
		csvFormat.add(event);
		csvFormat.add(mail);
		csvFormat.add(job);
		csvFormat.add(syslog);
		csvFormat.add(command);
		
		return csvFormat;
	}
}