/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool;

import java.util.Arrays;

import javax.naming.NamingException;

import jp.co.intellilink.hinemos.importtool.master.mib.ImportMib;
import jp.co.intellilink.hinemos.util.LoginManager;
import jp.co.intellilink.hinemos.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * ImportMaster メインクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ImportMaster {
	// main関数に与えられる引数
	private static String mode = "";

	// ログ出力
	private static Log log = LogFactory.getLog(ImportMaster.class);

	/**
	 * メイン
	 * 
	 * @param args
	 */
	public static void main(String[] args) {

		// 実行ログを記載
		log.info(Messages.getMsg("ImportTool.Exec") + " : " + Arrays.toString(args));

		// 引数の数の確認
		if (args.length == 0) {
			log.error(Messages.getMsg("ArgsInvalid"));
			System.exit(11);
		}

		// 引数の格納
		mode = args[0];

		if(mode.equalsIgnoreCase("mib")){
			//MIB
			
			String[] filePaths = new String[args.length - 1];
			for (int i = 1; i < args.length; i++) {
				filePaths[i-1] = args[i];
			}
		    
			ImportMib mib = new ImportMib();
			mib.importMib(filePaths);
		}
		else{
			log.error(Messages.getMsg("ModeNotFound"));
			System.exit(12);
		}
		
		// マネージャー接続の切断
		try {
			LoginManager.getContextManager().logout();
		} catch (NamingException e) {
			log.warn(Messages.getMsg("DisconnectManagerFailed"), e);
		}

		// 正常終了
		log.info(Messages.getMsg("ImportTool.Exit"));
		System.exit(0);
	}
}
