/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.check;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;

import javax.naming.NamingException;

import jp.co.intellilink.hinemos.check.conf.CheckMonitor;
import jp.co.intellilink.hinemos.check.conf.CheckMonitorAgent;
import jp.co.intellilink.hinemos.check.conf.CheckMonitorHttp;
import jp.co.intellilink.hinemos.check.conf.CheckMonitorPerformance;
import jp.co.intellilink.hinemos.check.conf.CheckMonitorPing;
import jp.co.intellilink.hinemos.check.conf.CheckMonitorPort;
import jp.co.intellilink.hinemos.check.conf.CheckMonitorProcess;
import jp.co.intellilink.hinemos.check.conf.CheckMonitorSnmp;
import jp.co.intellilink.hinemos.check.conf.CheckMonitorSnmpTrap;
import jp.co.intellilink.hinemos.check.conf.CheckMonitorSql;
import jp.co.intellilink.hinemos.check.conf.CheckMonitorSyslogng;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.LoginManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * CheckConf メインクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class CheckConf {
	// main関数に与えられる引数
	private static String mode = "all";

	// ログ出力
	private static Log log = LogFactory.getLog(CheckConf.class);

	/**
	 * メイン
	 * 
	 * @param args
	 */
	@SuppressWarnings("unchecked")
	public static void main(String[] args) {

		// 実行ログを記載
		log.info(Messages.getMsg("CheckTool.Exec") + " : " + Arrays.toString(args));

		// 引数の数の確認
		if (args.length > 1) {
			log.error(Messages.getMsg("ArgsInvalid"));
			System.exit(11);
		}

		// 引数の格納
		if(args.length == 0 || args[0].equals(""))
			mode = "all";
		else if(args.length == 1)
			mode = args[0];

		ArrayList<ArrayList<String>> csvOutput = new ArrayList<ArrayList<String>>();

		if(mode.equalsIgnoreCase("ping") || mode.equalsIgnoreCase("all")){
			//Ping監視
			CheckMonitorPing ping = new CheckMonitorPing();
			csvOutput.add(ping.checkPing());
		}
		if(mode.equalsIgnoreCase("agent") || mode.equalsIgnoreCase("all")){
			//エージェント監視
			CheckMonitorAgent agent = new CheckMonitorAgent();
			csvOutput.add(agent.checkAgent());
		}
		if(mode.equalsIgnoreCase("process") || mode.equalsIgnoreCase("all")){
			//プロセス監視
			CheckMonitorProcess process = new CheckMonitorProcess();
			csvOutput.add(process.checkProcess());
		}
		if(mode.equalsIgnoreCase("resource") || mode.equalsIgnoreCase("all")){
			//リソース監視
			CheckMonitorPerformance perf = new CheckMonitorPerformance();
			csvOutput.add(perf.checkPerformance());
		}
		if(mode.equalsIgnoreCase("syslog") || mode.equalsIgnoreCase("all")){
			//syslog-ng監視
			CheckMonitorSyslogng syslog = new CheckMonitorSyslogng();
			csvOutput.add(syslog.checkSyslogng());
		}
		if(mode.equalsIgnoreCase("snmp") || mode.equalsIgnoreCase("all")){
			//SNMP監視
			CheckMonitorSnmp snmpNum = new CheckMonitorSnmp();
			csvOutput.add(snmpNum.checkSnmp());
		}
		if(mode.equalsIgnoreCase("trap") || mode.equalsIgnoreCase("all")){
			//SNMPTRAP監視
			CheckMonitorSnmpTrap trap = new CheckMonitorSnmpTrap();
			csvOutput.add(trap.checkSnmpTrap());
		}
		if(mode.equalsIgnoreCase("port") || mode.equalsIgnoreCase("all")){
			//サービス・ポート監視
			CheckMonitorPort port = new CheckMonitorPort();
			csvOutput.add(port.checkPort());
		}
		if(mode.equalsIgnoreCase("http") || mode.equalsIgnoreCase("all")){
			//HTTP監視
			CheckMonitorHttp httpNum = new CheckMonitorHttp();
			csvOutput.add(httpNum.checktHttp());
		}
		if(mode.equalsIgnoreCase("sql") || mode.equalsIgnoreCase("all")){
			//SQL監視
			CheckMonitorSql sqlNum = new CheckMonitorSql();
			csvOutput.add(sqlNum.checkSql());
		}
//		else{
//		log.error(Messages.getMsg("ExportTool.ModeNotFound"));
//		System.exit(12);
//		}

		int monitorCount = 0;
		int nodeCount = 0;
		int notifyCount = 0;
		for(ArrayList<String> line : csvOutput){
			monitorCount = monitorCount + Integer.parseInt(line.get(1));
			nodeCount = nodeCount + Integer.parseInt(line.get(2));
			notifyCount = notifyCount + Integer.parseInt(line.get(3));
		}
		ArrayList<String> total = new ArrayList<String>();
		total.add("Total");
		total.add(String.valueOf(monitorCount));
		total.add(String.valueOf(nodeCount));
		total.add(String.valueOf(notifyCount));

		//監視種別でソート
		Collections.sort(csvOutput, new StringListComparator(0));
		csvOutput.add(0, CheckMonitor.createOutputHeader());
		csvOutput.add(total);

		SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HHmmss");

		WriteCsvFile.writeCsvFile(
				Config.getConfig("Export.Dir") + "/CHECK_" + format.format(new Date()) + ".csv", 
				csvOutput);

		// マネージャー接続の切断
		try {
			LoginManager.getContextManager().logout();
		} catch (NamingException e) {
			log.warn(Messages.getMsg("DisconnectManagerFailed"), e);
		}

		// 正常終了
		log.info(Messages.getMsg("CheckTool.Exit"));
		System.exit(0);
	}
}
