/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.export.conf.monitor;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;

import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.IntegerListComparator;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;
import com.clustercontrol.snmp.bean.SnmpCheckInfo;
import com.clustercontrol.snmp.ejb.session.MonitorSnmpController;

/**
 * SNMP監視情報を取得するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ExportMonitorSnmpString extends ExportMonitorString {

	// ログ出力
	private static Log log = LogFactory.getLog(ExportMonitorSnmpString.class);

	/**
	 * SNMP監視情報をExportする。<br>
	 */
	public void exportSnmp() {
		log.info(Messages.getMsg("Snmp.Start", new String[]{Messages.getMsg("ExportTool.Export")}));

		//CSV出力配列を用意
		ArrayList<ArrayList<String>> csvMainOutput = new ArrayList<ArrayList<String>>();
		ArrayList<ArrayList<String>> csvRuleOutput = new ArrayList<ArrayList<String>>();

		//監視項目リスト取得
		ArrayList idList = getSnmpList();

		if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				MonitorInfo info = (MonitorInfo)itr.next();
				if(info.getMonitorType() == MonitorTypeConstant.TYPE_STRING){
					Object[] args = {info.getMonitorId()};
					log.info(Messages.getMsg("MonitorID", args));
					csvMainOutput.add(createCsvFormat(info));
					csvRuleOutput.addAll(createMonitorJudgement(info));
				}
			}

			//監視項目IDでソート
			Collections.sort(csvMainOutput, new StringListComparator(0));

			//監視項目IDと順序でソート
			Collections.sort(csvRuleOutput, new IntegerListComparator(1));
			Collections.sort(csvRuleOutput, new StringListComparator(0));
		}

		String timestamp = "";
		if(Config.getConfig("file.timestamp").equalsIgnoreCase("on")){
			SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HHmmss");
			timestamp = "_" + format.format(new Date());
		}
		WriteCsvFile.writeCsvFile(
				Config.getConfig("Export.Dir") + "/SNMP_STR" + timestamp + ".csv", 
				csvMainOutput);

		WriteCsvFile.writeCsvFile(
				Config.getConfig("Export.Dir") + "/SNMP_STR_RULE" + timestamp + ".csv", 
				csvRuleOutput);

		log.info(Messages.getMsg("Snmp.End", new String[]{Messages.getMsg("ExportTool.Export")}));
	}

	/**
	 * SNMP監視情報をExportする。<br>
	 * 
	 * @param monitorInfo SNMP監視情報
	 * @return CSVフォーマット文字列
	 */
	@Override
	public ArrayList<String> createMonitorInfo(MonitorInfo monitorInfo) {
		ArrayList<String> csvFormat = new ArrayList<String>();

		SnmpCheckInfo snmpInfo = (SnmpCheckInfo)monitorInfo.getSnmpCheckInfo();
		if(snmpInfo == null){
			snmpInfo = new SnmpCheckInfo();
		}
		//コミュニティ名
		if (snmpInfo.getCommunityName() != null)
			csvFormat.add(snmpInfo.getCommunityName());
		else
			csvFormat.add("");
		//ポート番号
		if (snmpInfo.getSnmpPort() != null)
			csvFormat.add(snmpInfo.getSnmpPort().toString());
		else
			csvFormat.add("");
		//OID
		if (snmpInfo.getSnmpOid() != null)
			csvFormat.add(snmpInfo.getSnmpOid());
		else
			csvFormat.add("");
		//バージョン
		if (snmpInfo.getSnmpVersion() != null)
			csvFormat.add(snmpInfo.getSnmpVersion());
		else
			csvFormat.add("");

		return csvFormat;
	}

	/**
	 * 監視項目リストを取得する。<br>
	 * 
	 * @return 監視項目一覧
	 */
	protected ArrayList getSnmpList() {

		MonitorSnmpController snmp = EjbConnectionManager.getConnectionManager().getMonitorSnmpController();

		ArrayList records = null;
		try {
			records = snmp.getSnmpList();
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return records;
	}
}