/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.export.history;

import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.FacilityNotFoundException;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.monitor.bean.StatusInfoData;
import com.clustercontrol.monitor.ejb.session.MonitorController;

/**
 * ステータスをCSV出力するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ExportStatus {

	// ログ出力
	private static Log log = LogFactory.getLog(ExportStatus.class);

	/**
	 * ステータスをCSV出力する。<br>
	 */
	public void export() {
		log.info(Messages.getMsg("ExportTool.Status.Start"));

		//CSV出力配列を用意
		ArrayList<ArrayList<String>> csvOutput = new ArrayList<ArrayList<String>>();

		ArrayList<StatusInfoData> statuses = getStatus();

		for(StatusInfoData status : statuses){
			csvOutput.addAll(createStatus(status));
		}

		//ファシリティIDでソート
		Collections.sort(csvOutput, new StringListComparator(3));
		//監視項目IDでソート
		Collections.sort(csvOutput, new StringListComparator(2));
		//プラグインIDでソート
		Collections.sort(csvOutput, new StringListComparator(1));

		csvOutput.add(0, createHeader());

		SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HHmmss");

		WriteCsvFile.writeCsvFile(
				Config.getConfig("History.Dir") + "/STATUS_" + format.format(new Date()) + ".csv", 
				csvOutput);

		log.info(Messages.getMsg("ExportTool.Status.End"));
	}

	/**
	 * CSVフォーマットのヘッダ文字列を作成する。<br>
	 * 
	 * @return CSVフォーマット文字列
	 */
	public ArrayList<String> createHeader() {
		ArrayList<String> csvFormat = new ArrayList<String>();

		csvFormat.add(com.clustercontrol.util.Messages.getString("priority"));
		csvFormat.add(com.clustercontrol.util.Messages.getString("plugin.id"));
		csvFormat.add(com.clustercontrol.util.Messages.getString("monitor.id"));
		csvFormat.add(com.clustercontrol.util.Messages.getString("facility.id"));
		csvFormat.add(com.clustercontrol.util.Messages.getString("scope"));
		csvFormat.add(com.clustercontrol.util.Messages.getString("application"));
		csvFormat.add(com.clustercontrol.util.Messages.getString("update.time"));
		csvFormat.add(com.clustercontrol.util.Messages.getString("output.time"));
		csvFormat.add(com.clustercontrol.util.Messages.getString("message.id"));
		csvFormat.add(com.clustercontrol.util.Messages.getString("message"));

		return csvFormat;
	}

	/**
	 * ステータス情報からCSVフォーマット文字列を作成する。<br>
	 * 
	 * @param status ステータス情報
	 * @return CSVフォーマット文字列
	 */
	public ArrayList<ArrayList<String>> createStatus(StatusInfoData status) {
		ArrayList<ArrayList<String>> csvFormat = new ArrayList<ArrayList<String>>();
		ArrayList<String> csvLine = new ArrayList<String>();

		DateFormat format = DateFormat.getDateTimeInstance();

		//重要度
		csvLine.add(PriorityConstant.typeToString(status.getPriority()));
		//プラグインID
		csvLine.add(status.getPluginId());
		//監視項目ID
		csvLine.add(status.getMonitorId());
		//ファシリティID
		csvLine.add(status.getFacilityId());
		//スコープ
		csvLine.add(status.getFacilityPath());
		//アプリケーション
		csvLine.add(status.getApplication());
		//最終更新日時
		csvLine.add(format.format(status.getOutputDate()));
		//出力日時
		csvLine.add(format.format(status.getGenerationDate()));
		//メッセージID
		csvLine.add(status.getMessageId());
		//メッセージ
		csvLine.add(status.getMessage());

		csvFormat.add(csvLine);

		return csvFormat;
	}

	/**
	 * ステータス情報を取得する。<br>
	 * 
	 * @return ステータス情報
	 */
	public synchronized ArrayList<StatusInfoData> getStatus() {
		MonitorController monitor = 
			EjbConnectionManager.getConnectionManager().getMonitorController();

		ArrayList records = null;
		try {
			records = monitor.getStatusList(null);
		} catch (RemoteException e) {
		} catch (CreateException e) {
		} catch (NamingException e) {
		} catch (FacilityNotFoundException e) {
		}

		return records;
	}
}