/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.calendar;

import java.util.ArrayList;
import java.util.Iterator;

import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.calendar.ejb.session.CalendarController;

/**
 * カレンダ情報を削除するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class DeleteCalendar {

	// ログ出力
	private static Log log = LogFactory.getLog(DeleteCalendar.class);

	/**
	 * カレンダ情報を削除する。<br>
	 */
	@SuppressWarnings("unchecked")
	public void delete() {
		log.info(Messages.getMsg("Calendar.Start", new String[]{Messages.getMsg("ImportTool.Delete")}));

		//カレンダ一覧取得
		ArrayList idList = getCalendarList();

		if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				ArrayList line = (ArrayList)itr.next();

				deleteCalendarInfo((String)line.get(0));
			}
		}

		log.info(Messages.getMsg("Calendar.End", new String[]{Messages.getMsg("ImportTool.Delete")}));
	}

	/**
	 * カレンダ情報を削除する。<br>
	 * 
	 * @param calendarId カレンダID
	 */
	protected void deleteCalendarInfo(String calendarId) {
		CalendarController cal = EjbConnectionManager.getConnectionManager().getCalendarController();

		try {
			Object[] args = {calendarId};
			log.info(Messages.getMsg("CalendarID", args) + 
					" (" + Messages.getMsg("modify") + ")");

			cal.deleteCalendar(calendarId);
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
	}

	/**
	 * カレンダ一覧を取得する。<br>
	 * 
	 * @return カレンダ一覧
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList getCalendarList() {

		CalendarController cal = EjbConnectionManager.getConnectionManager().getCalendarController();

		ArrayList list = null;
		try {
			list = cal.getCalendarList();
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return list;
	}
}