/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.monitor;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.sql.bean.SqlCheckInfo;
import com.clustercontrol.sql.ejb.session.MonitorSqlController;
import java.util.ArrayList;
import java.util.List;
import jp.co.intellilink.hinemos.export.conf.monitor.JdbcDriverUtil;
import jp.co.intellilink.hinemos.importtool.conf.monitor.ImportMonitorString;
import jp.co.intellilink.hinemos.util.CheckString;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.ReadCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportMonitorSqlString
extends ImportMonitorString {
    private static Log log = LogFactory.getLog(ImportMonitorSqlString.class);
    private ArrayList monitorList = null;
    private ArrayList<ArrayList<String>> monitorInfos = null;
    private List<List<String>> driverList = JdbcDriverUtil.getJdbcDriver();

    public void importSql() {
        log.info((Object)Messages.getMsg("Sql.Start", new String[]{Messages.getMsg("ImportTool.Import")}));
        this.monitorInfos = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/SQL_STR.csv");
        this.monitorRuleInfos = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/SQL_STR_RULE.csv");
        this.monitorList = this.getMonitorList();
        for (ArrayList<String> arrayList : this.monitorInfos) {
            MonitorInfo monitorInfo = this.createMonitorInfo(arrayList);
            this.registerMonitorInfo(monitorInfo);
        }
        log.info((Object)Messages.getMsg("Sql.End", new String[]{Messages.getMsg("ImportTool.Import")}));
    }

    @Override
    protected MonitorInfo createMonitorInfo(ArrayList<String> arrayList) {
        MonitorInfo monitorInfo = new MonitorInfo();
        this.createMonitorBase(arrayList, monitorInfo);
        this.createMonitorRule(arrayList.subList(3, 5), monitorInfo);
        this.createMonitorCheck(arrayList.subList(5, 10), monitorInfo);
        this.createMonitorNotify(arrayList.subList(10, 16), monitorInfo);
        this.createMonitorApplication(arrayList.subList(16, 17), monitorInfo);
        if (arrayList.get(17) instanceof String && arrayList.get(17).length() > 0) {
            monitorInfo.setFailurePriority(PriorityConstant.stringToType((String)arrayList.get(16)));
        }
        this.createMonitorVaild(arrayList.subList(18, 19), monitorInfo);
        this.createMonitorJudgement(monitorInfo);
        return monitorInfo;
    }

    @Override
    protected void createMonitorCheck(List<String> list, MonitorInfo monitorInfo) {
        Object[] objectArray;
        Object object;
        Object object2;
        SqlCheckInfo sqlCheckInfo = new SqlCheckInfo();
        String string = CheckString.checkLength(list.get(0), 256);
        if (!string.equals(list.get(0))) {
            object2 = new String[]{com.clustercontrol.util.Messages.getString((String)"connection.url"), "256"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", (Object[])object2));
        }
        sqlCheckInfo.setConnectionUrl(string);
        object2 = this.driverList.iterator();
        while (object2.hasNext()) {
            object = (List)object2.next();
            objectArray = (Object[])object.get(0);
            if (!objectArray.equals(list.get(1))) continue;
            sqlCheckInfo.setJdbcDriver((String)object.get(1));
            break;
        }
        if (!((String)(object2 = CheckString.checkLength(list.get(2), 64))).equals(list.get(2))) {
            object = new String[]{com.clustercontrol.util.Messages.getString((String)"user.id"), "64"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", object));
        }
        sqlCheckInfo.setUser((String)object2);
        object = CheckString.checkLength(list.get(3), 64);
        if (!object.equals(list.get(3))) {
            objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"password"), "64"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
        }
        sqlCheckInfo.setPassword((String)object);
        objectArray = CheckString.checkLength(list.get(4), 1024);
        if (!objectArray.equals(list.get(4))) {
            Object[] objectArray2 = new String[]{com.clustercontrol.util.Messages.getString((String)"sql.string"), "1024"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray2));
        }
        sqlCheckInfo.setQuery((String)objectArray);
        monitorInfo.setSqlCheckInfo(sqlCheckInfo);
        monitorInfo.setMonitorType(2);
        super.createMonitorCheck(list, monitorInfo);
    }

    protected void registerMonitorInfo(MonitorInfo monitorInfo) {
        MonitorSqlController monitorSqlController = EjbConnectionManager.getConnectionManager().getMonitorSqlController();
        try {
            MonitorInfo monitorInfo2 = this.checkMonitorList(monitorInfo.getMonitorId(), this.monitorList);
            if (monitorInfo2 instanceof MonitorInfo) {
                monitorInfo.setRegDate(monitorInfo2.getRegDate());
                monitorInfo.setRegUser(monitorInfo2.getRegUser());
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("MonitorID", objectArray) + " (" + Messages.getMsg("modify") + ")"));
                monitorSqlController.modifySql(monitorInfo);
            } else {
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("MonitorID", objectArray) + " (" + Messages.getMsg("add") + ")"));
                monitorSqlController.addSql(monitorInfo);
            }
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected ArrayList getMonitorList() {
        MonitorSqlController monitorSqlController = EjbConnectionManager.getConnectionManager().getMonitorSqlController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorSqlController.getSqlList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

