/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.util;

import java.util.Locale;

import javax.ejb.FinderException;

import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.jobmanagement.bean.SystemParameterConstant;
import com.clustercontrol.repository.ejb.session.RepositoryController;

/**
 * リポジトリユーティリティクラス
 * リポジトリに関するユーティリティを格納するクラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class RepositoryUtil {

	/**
	 * ファシリティIDが存在するかチェックする<BR>
	 * 
	 * @param facilityId ファシリティID
	 * @return 結果
	 */
	public static boolean findFacilityId(String facilityId) {
		boolean find = false;

		RepositoryController repository = 
			EjbConnectionManager.getConnectionManager().getRepositoryController();

		try {
			if(facilityId.compareTo(
					SystemParameterConstant.HEADER + 
					SystemParameterConstant.FACILITY_ID + 
					SystemParameterConstant.FOOTER) == 0)
				find = true;
			else if(repository.isNode(facilityId))
				find = true;
			else{
				repository.getScopeProperty(
						facilityId, 
						PropertyConstant.MODE_SHOW, 
						Locale.getDefault());
				find = true;
			}
		} catch (FinderException e) {
		} catch (Exception e) {
		}

		return find;
	}
}