/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.monitor;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.ejb.DuplicateKeyException;

import jp.co.intellilink.hinemos.importtool.util.Config;
import jp.co.intellilink.hinemos.importtool.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.importtool.util.Messages;
import jp.co.intellilink.hinemos.importtool.util.ReadCsvFile;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.PortRunCountConstant;
import com.clustercontrol.bean.PortRunIntervalConstant;
import com.clustercontrol.bean.ProtocolConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTabelDefine;
import com.clustercontrol.port.bean.MonitorPortInfo;
import com.clustercontrol.port.ejb.session.MonitorPortController;

/**
 * サービス・ポート監視情報をインポートするクラス<br>
 * 
 * @version 1.1.0
 * @since 1.1.0
 */
public class ImportMonitorPort extends ImportMonitorNumeric {

	// ログ出力
	private static Log log = LogFactory.getLog(ImportMonitorPort.class);

	@SuppressWarnings("unchecked")
	private ArrayList monitorList = null;

	private ArrayList<ArrayList<String>> monitorInfos = null;

	/**
	 * サービス・ポート監視情報をインポートする。<br>
	 */
	public void importPort() {
		log.info(Messages.getMsg("ImportTool.Port.Start", new String[]{Messages.getMsg("ImportTool.Import")}));

		//Ping監視情報のCSVファイルを読み込む
		monitorInfos = ReadCsvFile.readCsvFile(Config.getConfig("Input.Dir.Conf") + "/PORT.csv");

		//監視項目リスト取得
		monitorList = getMonitorList();

		for(ArrayList<String> info : monitorInfos){
			MonitorInfo monitorInfo = createMonitorInfo(info);
			registerMonitorInfo(monitorInfo);
		}

		log.info(Messages.getMsg("ImportTool.Port.End", new String[]{Messages.getMsg("ImportTool.Import")}));
	}

	/**
	 * 監視情報オブジェクトを作成する。<br>
	 * 
	 * @see jp.co.intellilink.hinemos.importtool.conf.monitor.ImportMonitor#createMonitorInfo(java.util.ArrayList)
	 */
	@Override
	protected MonitorInfo createMonitorInfo(ArrayList<String> info){
		MonitorInfo monitorInfo = new MonitorInfo();

		//監視基本情報
		createMonitorBase(info, monitorInfo);

		//監視条件情報
		createMonitorRule(info.subList(3, 5), monitorInfo);

		//監視情報
		createMonitorCheck(info.subList(5, 10), monitorInfo);

		//監視単位情報
		createMonitorBlock(info.subList(10, 11), monitorInfo);

		//監視判定情報
		createMonitorJudgement(info.subList(11, 16), monitorInfo);

		//監視通知情報
		createMonitorNotify(info.subList(16, 21), monitorInfo);

		//アプリケーション
		createMonitorApplication(info.subList(21, 22), monitorInfo);

		//有効/無効
		createMonitorVaild(info.subList(22, 23), monitorInfo);

		return monitorInfo;
	}

	/**
	 * サービス・ポート監視情報を設定する。<br>
	 * 
	 * @param info 監視情報配列
	 * @param monitorInfo 監視情報オブジェクト
	 * 
	 * @see jp.co.intellilink.hinemos.importtool.conf.monitor.ImportMonitor#createMonitorCheck(java.util.List, com.clustercontrol.monitor.run.bean.MonitorInfo)
	 */
	@Override
	protected void createMonitorCheck(List<String> info, MonitorInfo monitorInfo) {
		MonitorPortInfo portInfo = new MonitorPortInfo();

		//TCP・サービスプロトコル
		if(info.get(0) instanceof String && 
				info.get(0).compareTo(com.clustercontrol.util.Messages.getString("tcp.connect.only")) == 0){
			portInfo.setServiceId(ProtocolConstant.TYPE_PROTOCOL_TCP);
		}
		else{
			portInfo.setServiceId("");
		}
		//ポート番号
		portInfo.setPortNo(Integer.parseInt(info.get(1)));
		//試行回数
		portInfo.setRunCount(PortRunCountConstant.stringToType(info.get(2)));
		//試行間隔
		portInfo.setRunInterval(PortRunIntervalConstant.stringToType(info.get(3)));
		//タイムアウト
		portInfo.setTimeout(Integer.parseInt(info.get(4)));

		monitorInfo.setCheckInfo(portInfo);

		super.createMonitorCheck(info, monitorInfo);
	}

	/**
	 * 監視情報を登録する。<br>
	 * 
	 * @param info 監視情報オブジェクト
	 */
	protected void registerMonitorInfo(MonitorInfo info) {
		MonitorPortController port = EjbConnectionManager.getConnectionManager().getMonitorPortController();

		try {
			@SuppressWarnings("unchecked")
			ArrayList list = checkMonitorList(info.getMonitorId(), monitorList);
			if(list instanceof ArrayList){
				Date createTime = (Date)list.get(MonitorTabelDefine.CREATE_TIME);
				String createUser = (String)list.get(MonitorTabelDefine.CREATE_USER);
				info.setRegDate(new Timestamp(createTime.getTime()));
				info.setRegUser(createUser);

				Object[] args = {info.getMonitorId()};
				log.info(Messages.getMsg("ImportTool.MonitorID", args) + 
						" (" + Messages.getMsg("modify") + ")");

				port.modifyPort(info);
			}
			else{
				Object[] args = {info.getMonitorId()};
				log.info(Messages.getMsg("ImportTool.MonitorID", args) + 
						" (" + Messages.getMsg("add") + ")");

				port.addPort(info);
			}
		} catch (DuplicateKeyException e) {
			String args[] = {info.getMonitorId()};
			log.error(Messages.getMsg("ImportTool.Common.1", args));
			System.exit(20);
		} catch (Exception e) {
			log.error(Messages.getMsg("ImportTool.ConnectManagerFailed"), e);
			System.exit(14);
		}
	}

	/**
	 * 監視項目リストを取得する。<br>
	 * 
	 * @return 監視項目一覧
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList getMonitorList() {

		MonitorPortController port = EjbConnectionManager.getConnectionManager().getMonitorPortController();

		ArrayList records = null;
		try {
			records = port.getPortList();
		} catch (Exception e) {
			log.error(Messages.getMsg("ImportTool.ConnectManagerFailed"), e);
			System.exit(14);
		}
		return records;
	}
}