/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.testing.common;

import com.jcoverage.coverage.BcelCoverageInstrumenter;
import java.io.File;
import java.io.IOException;
import jp.co.dgic.testing.common.AbstractBcelModifier;
import jp.co.dgic.testing.common.BcelJUnit4AnnotationReader;
import jp.co.dgic.testing.common.IClassModifier;
import jp.co.dgic.testing.common.virtualmock.BcelAdviceImplementer;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;

public class BcelClassModifier
implements IClassModifier {
    private AbstractBcelModifier modifier = new BcelCoverageInstrumenter();

    public BcelClassModifier() {
        BcelAdviceImplementer bcelAdviceInplementer = new BcelAdviceImplementer();
        this.modifier.setNext(bcelAdviceInplementer);
    }

    public byte[] getModifiedClass(String className) throws Exception {
        if (this.isTestCase(className)) {
            return null;
        }
        return this.modifier.getModifiedByteCode(Repository.lookupClass((String)className));
    }

    public byte[] modifyClass(String className) throws Exception {
        return this.modifier.getModifiedByteCode(Repository.lookupClass((String)className));
    }

    private boolean isTestCase(String className) throws ClassNotFoundException {
        JavaClass testCase = Repository.lookupClass((String)"junit.framework.TestCase");
        JavaClass jc = Repository.lookupClass((String)className);
        if (jc.instanceOf(testCase)) {
            return true;
        }
        BcelJUnit4AnnotationReader reader = new BcelJUnit4AnnotationReader(jc);
        return reader.hasJUnit4Annotation();
    }

    public void writeFile(String className) throws IOException, ClassNotFoundException {
        JavaClass jc = Repository.lookupClass((String)className);
        jc.dump(className);
    }

    public void writeFile(String className, String directoryName) throws IOException, ClassNotFoundException {
        JavaClass jc = Repository.lookupClass((String)className);
        jc.dump(new File(String.valueOf(directoryName) + "/" + className + ".class"));
    }
}

