/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.monitor;

import com.clustercontrol.bean.RunIntervalConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.hinemosagent.bean.MonitorAgentInfo;
import com.clustercontrol.http.bean.MonitorHttpInfo;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.notify.bean.NotifyRelationInfo;
import com.clustercontrol.performance.monitor.bean.MonitorPerfCheckInfo;
import com.clustercontrol.ping.bean.MonitorPingInfo;
import com.clustercontrol.port.bean.MonitorPortInfo;
import com.clustercontrol.process.bean.MonitorProcessInfo;
import com.clustercontrol.snmp.bean.MonitorSnmpInfo;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapInfo;
import com.clustercontrol.sql.bean.MonitorSqlInfo;
import com.clustercontrol.syslogng.bean.LogFilterInfo;
import java.util.ArrayList;
import java.util.List;
import jp.co.intellilink.hinemos.importtool.util.CheckString;
import jp.co.intellilink.hinemos.importtool.util.Messages;
import jp.co.intellilink.hinemos.importtool.util.NotifyUtil;
import jp.co.intellilink.hinemos.importtool.util.RepositoryUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportMonitor {
    private static Log log = LogFactory.getLog(ImportMonitor.class);

    protected MonitorInfo createMonitorInfo(ArrayList<String> arrayList) {
        MonitorInfo monitorInfo = new MonitorInfo();
        return monitorInfo;
    }

    protected void createMonitorBase(List<String> list, MonitorInfo monitorInfo) {
        Object[] objectArray;
        Object[] objectArray2;
        String string = CheckString.checkLength(list.get(0), 64);
        if (!string.equals(list.get(0))) {
            objectArray2 = new String[]{com.clustercontrol.util.Messages.getString((String)"monitor.id"), "64"};
            log.error((Object)Messages.getMsg("ImportTool.Common.2", objectArray2));
            System.exit(20);
        }
        monitorInfo.setMonitorId(string);
        objectArray2 = CheckString.checkLength(list.get(1), 256);
        if (!objectArray2.equals(list.get(1))) {
            objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"description"), "256"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
        }
        monitorInfo.setDescription((String)objectArray2);
        monitorInfo.setFacilityId(list.get(2));
        if (!RepositoryUtil.findFacilityId(list.get(2))) {
            objectArray = new String[]{monitorInfo.getMonitorId(), list.get(2)};
            log.error((Object)Messages.getMsg("ImportTool.Repository.1", objectArray));
            System.exit(20);
        }
    }

    protected void createMonitorBlock(List<String> list, MonitorInfo monitorInfo) {
        if (list.get(0).compareTo(com.clustercontrol.util.Messages.getString((String)"scope")) == 0) {
            monitorInfo.setMonitorBlock(1);
        } else {
            monitorInfo.setMonitorBlock(0);
        }
    }

    protected void createMonitorRule(List<String> list, MonitorInfo monitorInfo) {
        monitorInfo.setRunInterval(RunIntervalConstant.stringToType((String)list.get(0)));
        monitorInfo.setCalendarId(list.get(1));
    }

    protected void createMonitorCheck(List<String> list, MonitorInfo monitorInfo) {
        monitorInfo.setMonitorTypeId(this.instanceToTypeId(monitorInfo));
    }

    protected void createMonitorNotify(List<String> list, MonitorInfo monitorInfo) {
        monitorInfo.setNotifyGroupId(NotifyRelationInfo.createNotifyGroupId((String)this.instanceToTypeId(monitorInfo), (String)monitorInfo.getMonitorId()));
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        for (int i = 0; i < 5; ++i) {
            Object[] objectArray;
            if (!(list.get(i) instanceof String) || list.get(i).length() <= 0) continue;
            if (!NotifyUtil.findNotifyId(list.get(i))) {
                objectArray = new String[]{monitorInfo.getMonitorId(), list.get(i)};
                log.error((Object)Messages.getMsg("ImportTool.Notify.1", objectArray));
                System.exit(20);
            }
            objectArray = new NotifyRelationInfo();
            objectArray.setNotifyId(list.get(i));
            objectArray.setNotifyGroupId(monitorInfo.getNotifyGroupId());
            objectArray.setNotifyFlg(Integer.valueOf(0));
            if (i == 0) {
                objectArray.setNotifyType(Integer.valueOf(0));
            } else if (i == 1) {
                objectArray.setNotifyType(Integer.valueOf(1));
            } else if (i == 2) {
                objectArray.setNotifyType(Integer.valueOf(2));
            } else if (i == 3) {
                objectArray.setNotifyType(Integer.valueOf(3));
            } else if (i == 4) {
                objectArray.setNotifyType(Integer.valueOf(4));
            }
            arrayList.add(objectArray);
        }
        monitorInfo.setNotifyId(arrayList);
    }

    protected void createMonitorApplication(List<String> list, MonitorInfo monitorInfo) {
        String string = CheckString.checkLength(list.get(0), 64);
        if (!string.equals(list.get(0))) {
            Object[] objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"application"), "64"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
        }
        monitorInfo.setApplication(string);
    }

    protected void createMonitorVaild(List<String> list, MonitorInfo monitorInfo) {
        monitorInfo.setValid(ValidConstant.stringToType((String)list.get(0)));
    }

    protected ArrayList checkMonitorList(String string, ArrayList arrayList) {
        if (arrayList instanceof ArrayList) {
            for (ArrayList arrayList2 : arrayList) {
                String string2 = (String)arrayList2.get(0);
                if (string2.compareTo(string) != 0) continue;
                return arrayList2;
            }
        }
        return null;
    }

    protected String instanceToTypeId(MonitorInfo monitorInfo) {
        if (monitorInfo.getCheckInfo() instanceof MonitorAgentInfo) {
            return "MON_AGT";
        }
        if (monitorInfo.getCheckInfo() instanceof MonitorHttpInfo) {
            return "MON_HTP";
        }
        if (monitorInfo.getCheckInfo() instanceof MonitorPingInfo) {
            return "MON_PNG";
        }
        if (monitorInfo.getCheckInfo() instanceof MonitorProcessInfo) {
            return "MON_PRC";
        }
        if (monitorInfo.getCheckInfo() instanceof MonitorSnmpInfo) {
            return "MON_SNMP";
        }
        if (monitorInfo instanceof MonitorSnmpTrapInfo) {
            return "MON_SNMP_TRP";
        }
        if (monitorInfo.getCheckInfo() instanceof MonitorSqlInfo) {
            return "MON_SQL";
        }
        if (monitorInfo.getCheckInfo() instanceof MonitorPerfCheckInfo) {
            return "MON_PRF";
        }
        if (monitorInfo.getCheckInfo() instanceof MonitorPortInfo) {
            return "MON_PRT";
        }
        if (monitorInfo instanceof LogFilterInfo) {
            return "MON_LOG";
        }
        return "";
    }
}

