/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.performance;

import com.clustercontrol.bean.RunIntervalConstant;
import com.clustercontrol.performance.bean.CollectorItemInfo;
import com.clustercontrol.performance.bean.CollectorProperty;
import com.clustercontrol.performance.ejb.bmp.RecordCollectorData;
import com.clustercontrol.performance.ejb.session.CollectorController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.co.intellilink.hinemos.importtool.conf.performance.CollectorItemCodeFactory;
import jp.co.intellilink.hinemos.importtool.util.Config;
import jp.co.intellilink.hinemos.importtool.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.importtool.util.Messages;
import jp.co.intellilink.hinemos.importtool.util.ReadCsvFile;
import jp.co.intellilink.hinemos.importtool.util.RepositoryUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportPerformance {
    private static Log log = LogFactory.getLog(ImportPerformance.class);
    private ArrayList performanceList = null;
    private ArrayList<ArrayList<String>> monitorInfos = null;

    public void importPerformance() {
        log.info((Object)Messages.getMsg("ImportTool.Performance.Start", new String[]{Messages.getMsg("ImportTool.Import")}));
        this.monitorInfos = ReadCsvFile.readCsvFile(Config.getConfig("Input.Dir.Conf") + "/PERFORMANCE.csv");
        this.performanceList = this.getPerformanceList();
        for (ArrayList<String> arrayList : this.monitorInfos) {
            CollectorProperty collectorProperty = this.createCollectorProperty(arrayList);
            this.registerRecordColletor(collectorProperty);
        }
        log.info((Object)Messages.getMsg("ImportTool.Performance.End", new String[]{Messages.getMsg("ImportTool.Import")}));
    }

    protected CollectorProperty createCollectorProperty(ArrayList<String> arrayList) {
        Object object;
        CollectorProperty collectorProperty = new CollectorProperty();
        RecordCollectorData recordCollectorData = new RecordCollectorData();
        collectorProperty.setCollectorData(recordCollectorData);
        recordCollectorData.setCollectorID(arrayList.get(0));
        recordCollectorData.setLabel(arrayList.get(1));
        recordCollectorData.setFacilityID(arrayList.get(2));
        if (!RepositoryUtil.findFacilityId(arrayList.get(2))) {
            object = new String[]{recordCollectorData.getCollectorID(), arrayList.get(2)};
            log.error((Object)Messages.getMsg("ImportTool.Repository.1", (Object[])object));
            System.exit(14);
        }
        recordCollectorData.setIntervalSec(RunIntervalConstant.stringToType((String)arrayList.get(3)));
        if (arrayList.get(4).equals(Messages.getMsg("UNLIMIT_COLLECT"))) {
            recordCollectorData.setPeriodMin(-1);
            recordCollectorData.setPresavePeriod(Integer.parseInt(arrayList.get(8)));
        } else {
            int n = Integer.parseInt(arrayList.get(5)) * 24 * 60 + Integer.parseInt(arrayList.get(6)) * 60 + Integer.parseInt(arrayList.get(7));
            recordCollectorData.setPeriodMin(n);
        }
        object = CollectorItemCodeFactory.getAvailableCollectorItemList(recordCollectorData.getFacilityID());
        ArrayList<CollectorItemInfo> arrayList2 = new ArrayList<CollectorItemInfo>();
        List<String> list = arrayList.subList(9, arrayList.size());
        block0: for (String string : list) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                CollectorItemInfo collectorItemInfo = (CollectorItemInfo)iterator.next();
                String string2 = CollectorItemCodeFactory.getFullItemName(collectorItemInfo);
                if (!string2.equals(string)) continue;
                CollectorItemInfo collectorItemInfo2 = new CollectorItemInfo(recordCollectorData.getCollectorID(), collectorItemInfo.getCollectMethod(), collectorItemInfo.getItemCode(), collectorItemInfo.getDeviceName());
                arrayList2.add(collectorItemInfo2);
                continue block0;
            }
        }
        collectorProperty.setItemList(arrayList2);
        return collectorProperty;
    }

    protected void registerRecordColletor(CollectorProperty collectorProperty) {
        CollectorController collectorController = EjbConnectionManager.getConnectionManager().getCollectorController();
        try {
            boolean bl = false;
            if (this.performanceList instanceof ArrayList) {
                for (ArrayList arrayList : this.performanceList) {
                    String string = (String)arrayList.get(2);
                    if (string.compareTo(collectorProperty.getCollectorData().getCollectorID()) != 0) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                Object[] objectArray = new Object[]{collectorProperty.getCollectorData().getCollectorID()};
                log.info((Object)Messages.getMsg("ImportTool.CollectorID", objectArray));
                collectorController.createRecordColletor(collectorProperty);
            }
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ImportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected ArrayList getPerformanceList() {
        CollectorController collectorController = EjbConnectionManager.getConnectionManager().getCollectorController();
        ArrayList arrayList = null;
        try {
            arrayList = collectorController.getCollectionList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ImportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

