/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.test.job;

import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.ViewListInfo;
import com.clustercontrol.jobmanagement.bean.JobInfo;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.ejb.session.JobController;
import com.clustercontrol.util.PropertyUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import jp.co.intellilink.hinemos.test.util.Config;
import jp.co.intellilink.hinemos.test.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.test.util.Messages;
import jp.co.intellilink.hinemos.test.util.StringListComparator;
import jp.co.intellilink.hinemos.test.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckResultJob {
    private Date fromDate;
    private static Log log = LogFactory.getLog(CheckResultJob.class);

    public CheckResultJob(Date date) {
        this.fromDate = date;
    }

    public void checkResult() {
        log.info((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.Job.Start")));
        JobTreeItem jobTreeItem = this.getJobTree();
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        this.getJobData(jobTreeItem, arrayList);
        Collections.sort(arrayList, new StringListComparator(0));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Testcase.Output.Dir") + "/JOB_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        log.info((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.Job.End")));
    }

    public void getJobData(JobTreeItem jobTreeItem, ArrayList<ArrayList<String>> arrayList) {
        JobTreeItem[] jobTreeItemArray;
        if (jobTreeItem.getData() instanceof JobInfo && (jobTreeItemArray = jobTreeItem.getData()).getId() != null && jobTreeItemArray.getId().compareTo("") != 0) {
            JobTreeItem jobTreeItem2;
            Object[] objectArray = new Object[]{jobTreeItemArray.getId()};
            log.info((Object)Messages.getMsg("TestTool.JobID", objectArray));
            ArrayList<String> arrayList2 = this.createCsvFormat((JobInfo)jobTreeItemArray);
            String string = "";
            if (jobTreeItem.getParent() != null && jobTreeItem.getParent().getData() instanceof JobInfo && (jobTreeItem2 = jobTreeItem.getParent().getData()).getId() != null && jobTreeItem2.getId().compareTo("") != 0) {
                string = jobTreeItem2.getId();
            }
            arrayList2.add(4, string);
            arrayList.add(arrayList2);
        }
        jobTreeItemArray = jobTreeItem.getChildren();
        for (JobTreeItem jobTreeItem2 : jobTreeItemArray) {
            this.getJobData(jobTreeItem2, arrayList);
        }
    }

    public ArrayList<String> createCsvFormat(JobInfo jobInfo) {
        Iterator iterator;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(jobInfo.getId());
        arrayList.add(jobInfo.getName());
        arrayList.add(JobConstant.typeToString((int)jobInfo.getType()));
        ViewListInfo viewListInfo = this.getSessionList(jobInfo.getId());
        if (viewListInfo.getList() instanceof ArrayList && (iterator = viewListInfo.getList().iterator()).hasNext()) {
            Date date;
            ArrayList arrayList2 = (ArrayList)iterator.next();
            String string = "";
            String string2 = "";
            if (arrayList2.get(9) instanceof Date) {
                date = (Date)arrayList2.get(9);
                string = DateFormat.getDateTimeInstance().format(date);
            }
            if (arrayList2.get(11) instanceof Date) {
                date = (Date)arrayList2.get(11);
                string2 = DateFormat.getDateTimeInstance().format(date);
            }
            arrayList.add(string);
            arrayList.add(string2);
        }
        arrayList.add("");
        arrayList.add("");
        arrayList.add("");
        return arrayList;
    }

    protected ViewListInfo getSessionList(String string) {
        JobController jobController = EjbConnectionManager.getConnectionManager().getJobController();
        ViewListInfo viewListInfo = null;
        try {
            ArrayList arrayList = null;
            Property property = jobController.getHistoryFilterProperty(Locale.getDefault());
            if (string instanceof String) {
                arrayList = PropertyUtil.getProperty((Property)property, (String)"jobId");
                ((Property)arrayList.get(0)).setValue((Object)string);
            }
            if (this.fromDate instanceof Date) {
                arrayList = PropertyUtil.getProperty((Property)property, (String)"startFromDate");
                ((Property)arrayList.get(0)).setValue((Object)this.fromDate);
            }
            int n = Integer.parseInt(Config.getConfig("history.job.max.list"));
            viewListInfo = jobController.getHistoryList(property, n);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("TestTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return viewListInfo;
    }

    protected JobTreeItem getJobTree() {
        JobController jobController = EjbConnectionManager.getConnectionManager().getJobController();
        JobTreeItem jobTreeItem = null;
        try {
            jobTreeItem = jobController.getJobTree(true, Locale.getDefault());
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("TestTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return jobTreeItem;
    }
}

