/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.test.monitor.performance;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.performance.monitor.ejb.session.MonitorPerfController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import jp.co.intellilink.hinemos.test.monitor.ExportTestCaseMonitor;
import jp.co.intellilink.hinemos.test.util.Config;
import jp.co.intellilink.hinemos.test.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.test.util.Messages;
import jp.co.intellilink.hinemos.test.util.StringListComparator;
import jp.co.intellilink.hinemos.test.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExportTestCaseMonitorPerformance
extends ExportTestCaseMonitor {
    private static Log log = LogFactory.getLog(ExportTestCaseMonitorPerformance.class);

    public void exportTestCase() {
        log.info((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.Resource.Start")));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getPerformanceList();
        if (arrayList2 instanceof ArrayList) {
            for (ArrayList arrayList3 : arrayList2) {
                Object[] objectArray = new Object[]{(String)arrayList3.get(0)};
                log.info((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.MonitorID", objectArray)));
                MonitorInfo monitorInfo = this.getPerformance((String)arrayList3.get(0));
                arrayList.addAll(this.createTestCase(monitorInfo));
            }
            Collections.sort(arrayList, new StringListComparator(1));
            Collections.sort(arrayList, new StringListComparator(0));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Testcase.Output.Dir") + "/RESOURCE_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        log.info((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.Resource.End")));
    }

    protected MonitorInfo getPerformance(String string) {
        MonitorPerfController monitorPerfController = EjbConnectionManager.getConnectionManager().getMonitorPerfController();
        MonitorInfo monitorInfo = null;
        try {
            monitorInfo = monitorPerfController.getPerformance(string);
        }
        catch (Exception exception) {
            log.error((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
            System.exit(14);
        }
        return monitorInfo;
    }

    protected ArrayList getPerformanceList() {
        MonitorPerfController monitorPerfController = EjbConnectionManager.getConnectionManager().getMonitorPerfController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorPerfController.getPerformanceList();
        }
        catch (Exception exception) {
            log.error((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

