/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.test.monitor.ping;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.ping.ejb.session.MonitorPingController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import jp.co.intellilink.hinemos.test.monitor.ExportTestCaseMonitor;
import jp.co.intellilink.hinemos.test.util.Config;
import jp.co.intellilink.hinemos.test.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.test.util.Messages;
import jp.co.intellilink.hinemos.test.util.StringListComparator;
import jp.co.intellilink.hinemos.test.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExportTestCaseMonitorPing
extends ExportTestCaseMonitor {
    private static Log log = LogFactory.getLog(ExportTestCaseMonitorPing.class);

    public void exportTestCase() {
        log.info((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.Ping.Start")));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getPingList();
        if (arrayList2 instanceof ArrayList) {
            for (ArrayList arrayList3 : arrayList2) {
                Object[] objectArray = new Object[]{(String)arrayList3.get(0)};
                log.info((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.MonitorID", objectArray)));
                MonitorInfo monitorInfo = this.getPing((String)arrayList3.get(0));
                arrayList.addAll(this.createTestCase(monitorInfo));
            }
            Collections.sort(arrayList, new StringListComparator(1));
            Collections.sort(arrayList, new StringListComparator(0));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Testcase.Output.Dir") + "/PING_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        log.info((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.Ping.End")));
    }

    protected MonitorInfo getPing(String string) {
        MonitorPingController monitorPingController = EjbConnectionManager.getConnectionManager().getMonitorPingController();
        MonitorInfo monitorInfo = null;
        try {
            monitorInfo = monitorPingController.getPing(string);
        }
        catch (Exception exception) {
            log.error((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
            System.exit(14);
        }
        return monitorInfo;
    }

    protected ArrayList getPingList() {
        MonitorPingController monitorPingController = EjbConnectionManager.getConnectionManager().getMonitorPingController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorPingController.getPingList();
        }
        catch (Exception exception) {
            log.error((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

