/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.testing.common.coverage;

import com.jcoverage.coverage.Instrumentation;

public class CoverageEntry {
    private String name;
    private double branchCoverageRate;
    private long files;
    private long lines;
    private long hitLines;

    public CoverageEntry(String name) {
        this.name = name;
    }

    public long getBranchCoverageRate() {
        if (this.files == 0L) {
            return 0L;
        }
        return Math.round(this.getBranchCoverage() * 100.0);
    }

    public double getBranchCoverage() {
        return this.getScaledRate(this.branchCoverageRate / (double)this.files);
    }

    public void setBranchCoverage(double branchCoverage) {
        if (this.files == 0L) {
            this.branchCoverageRate = branchCoverage;
            return;
        }
        this.branchCoverageRate = branchCoverage * (double)this.files;
    }

    public String getName() {
        return this.name;
    }

    public long getLineCoverageRate() {
        if (this.lines == 0L) {
            return 0L;
        }
        return Math.round(this.getLineCoverage() * 100.0);
    }

    public double getLineCoverage() {
        if (this.files == 0L) {
            return 0.0;
        }
        return this.getScaledRate((double)this.hitLines / (double)this.lines);
    }

    public int getLengthOfLineCoverageRate() {
        return new Long(this.getLineCoverageRate()).toString().length();
    }

    public void addBranchCoverageRate(double branchCoverageRate) {
        this.branchCoverageRate += branchCoverageRate;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addHitLines(long hitLines) {
        this.hitLines += hitLines;
    }

    public void addLines(long lines) {
        this.lines += lines;
    }

    public long getFiles() {
        return this.files;
    }

    public long getLines() {
        return this.lines;
    }

    public long getHitLines() {
        return this.hitLines;
    }

    public void addInstrumentation(Instrumentation i) {
        this.addHitLines(i.getCoverage().keySet().size());
        this.addLines(i.getSourceLineNumbers().size());
        if (i.getLineCoverageRate() > 0.0) {
            this.addBranchCoverageRate(i.getBranchCoverageRate());
        }
        ++this.files;
    }

    public void addInstrumentation(CoverageEntry entry) {
        this.addBranchCoverageRate(entry.getBranchCoverage());
        this.addLines(entry.getLines());
        this.addHitLines(entry.getHitLines());
        ++this.files;
    }

    private double getScaledRate(double rate) {
        Double d = new Double(rate);
        String string = d.toString();
        int index = string.indexOf(46);
        if (index < 0) {
            return rate;
        }
        if (string.substring(index + 1).length() < 2) {
            return rate;
        }
        return Double.valueOf(string.substring(0, index + 3));
    }

    public String toString() {
        return String.valueOf(this.name) + " [" + this.getLineCoverage() + "(" + this.getLineCoverageRate() + "%)] [" + this.getBranchCoverage() + "(" + this.getBranchCoverageRate() + "%)] " + super.toString();
    }
}

