/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.monitor;

import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.hinemosagent.bean.MonitorAgentInfo;
import com.clustercontrol.hinemosagent.ejb.session.MonitorAgentController;
import com.clustercontrol.monitor.run.bean.MonitorCheckInfo;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ejb.DuplicateKeyException;
import jp.co.intellilink.hinemos.importtool.conf.monitor.ImportMonitorTruth;
import jp.co.intellilink.hinemos.importtool.util.Config;
import jp.co.intellilink.hinemos.importtool.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.importtool.util.Messages;
import jp.co.intellilink.hinemos.importtool.util.ReadCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportMonitorAgent
extends ImportMonitorTruth {
    private static Log log = LogFactory.getLog(ImportMonitorAgent.class);
    private ArrayList monitorList = null;
    private ArrayList<ArrayList<String>> monitorInfos = null;

    public void importAgent() {
        log.info((Object)Messages.getMsg("ImportTool.Agent.Start", new String[]{Messages.getMsg("ImportTool.Import")}));
        this.monitorInfos = ReadCsvFile.readCsvFile(Config.getConfig("Input.Dir.Conf") + "/AGENT.csv");
        this.monitorList = this.getMonitorList();
        for (ArrayList<String> arrayList : this.monitorInfos) {
            MonitorInfo monitorInfo = this.createMonitorInfo(arrayList);
            this.registerMonitorInfo(monitorInfo);
        }
        log.info((Object)Messages.getMsg("ImportTool.Agent.End", new String[]{Messages.getMsg("ImportTool.Import")}));
    }

    @Override
    protected MonitorInfo createMonitorInfo(ArrayList<String> arrayList) {
        MonitorInfo monitorInfo = new MonitorInfo();
        this.createMonitorBase(arrayList, monitorInfo);
        this.createMonitorRule(arrayList.subList(3, 5), monitorInfo);
        this.createMonitorCheck(arrayList.subList(5, 7), monitorInfo);
        this.createMonitorBlock(arrayList.subList(7, 8), monitorInfo);
        this.createMonitorJudgement(arrayList.subList(8, 11), monitorInfo);
        this.createMonitorNotify(arrayList.subList(11, 16), monitorInfo);
        this.createMonitorApplication(arrayList.subList(16, 17), monitorInfo);
        this.createMonitorVaild(arrayList.subList(17, 18), monitorInfo);
        return monitorInfo;
    }

    @Override
    protected void createMonitorCheck(List<String> list, MonitorInfo monitorInfo) {
        MonitorAgentInfo monitorAgentInfo = new MonitorAgentInfo();
        monitorAgentInfo.setCheckJobAgent(Integer.valueOf(YesNoConstant.stringToType((String)list.get(0))));
        monitorAgentInfo.setCheckLogAgent(Integer.valueOf(YesNoConstant.stringToType((String)list.get(1))));
        monitorInfo.setCheckInfo((MonitorCheckInfo)monitorAgentInfo);
        super.createMonitorCheck(list, monitorInfo);
    }

    protected void registerMonitorInfo(MonitorInfo monitorInfo) {
        MonitorAgentController monitorAgentController = EjbConnectionManager.getConnectionManager().getMonitorAgentController();
        try {
            ArrayList arrayList = this.checkMonitorList(monitorInfo.getMonitorId(), this.monitorList);
            if (arrayList instanceof ArrayList) {
                Date date = (Date)arrayList.get(8);
                String string = (String)arrayList.get(7);
                monitorInfo.setRegDate(new Timestamp(date.getTime()));
                monitorInfo.setRegUser(string);
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("ImportTool.MonitorID", objectArray) + " (" + Messages.getMsg("modify") + ")"));
                monitorAgentController.modifyAgent(monitorInfo);
            } else {
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("ImportTool.MonitorID", objectArray) + " (" + Messages.getMsg("add") + ")"));
                monitorAgentController.addAgent(monitorInfo);
            }
        }
        catch (DuplicateKeyException duplicateKeyException) {
            Object[] objectArray = new String[]{monitorInfo.getMonitorId()};
            log.error((Object)Messages.getMsg("ImportTool.Common.1", objectArray));
            System.exit(20);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ImportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected ArrayList getMonitorList() {
        MonitorAgentController monitorAgentController = EjbConnectionManager.getConnectionManager().getMonitorAgentController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorAgentController.getAgentList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ImportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

