/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpStatus;
import net.percederberg.mibble.snmp.SnmpType;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class SnmpObjectIdentity
extends SnmpType {
    private SnmpStatus status;
    private String reference;

    public SnmpObjectIdentity(SnmpStatus status, String description, String reference) {
        super("OBJECT-IDENTITY", description);
        this.status = status;
        this.reference = reference;
    }

    public MibType initialize(MibSymbol symbol, MibLoaderLog log) throws MibException {
        if (!(symbol instanceof MibValueSymbol)) {
            throw new MibException(symbol.getLocation(), "only values can have the " + this.getName() + " type");
        }
        return this;
    }

    public boolean isCompatible(MibValue value) {
        return value instanceof ObjectIdentifierValue;
    }

    public SnmpStatus getStatus() {
        return this.status;
    }

    public String getReference() {
        return this.reference;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append(" (");
        buffer.append("\n  Status: ");
        buffer.append(this.status);
        buffer.append("\n  Description: ");
        buffer.append(this.getDescription("               "));
        if (this.reference != null) {
            buffer.append("\n  Reference: ");
            buffer.append(this.reference);
        }
        buffer.append("\n)");
        return buffer.toString();
    }
}

