/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.monitor;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.ProcessConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.syslogng.bean.LogFilterInfo;
import com.clustercontrol.syslogng.ejb.session.SyslogNGController;
import java.util.ArrayList;
import java.util.List;
import jp.co.intellilink.hinemos.importtool.conf.monitor.ImportMonitor;
import jp.co.intellilink.hinemos.importtool.util.Config;
import jp.co.intellilink.hinemos.importtool.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.importtool.util.Messages;
import jp.co.intellilink.hinemos.importtool.util.ReadCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportMonitorSyslogng
extends ImportMonitor {
    private static Log log = LogFactory.getLog(ImportMonitorSyslogng.class);
    private ArrayList<LogFilterInfo> monitorList = null;
    private ArrayList<ArrayList<String>> monitorInfos = null;

    public void importSyslogng() {
        log.info((Object)Messages.getMsg("ImportTool.Syslogng.Start"));
        this.monitorInfos = ReadCsvFile.readCsvFile(Config.getConfig("Input.Dir.Conf") + "/SYSLOGNG.csv");
        this.monitorList = this.getMonitorList();
        ArrayList<LogFilterInfo> arrayList = new ArrayList<LogFilterInfo>();
        for (ArrayList<String> arrayList2 : this.monitorInfos) {
            MonitorInfo monitorInfo = this.createMonitorInfo(arrayList2);
            LogFilterInfo logFilterInfo = this.checkMonitorList(monitorInfo.getMonitorId(), this.monitorList);
            if (logFilterInfo instanceof LogFilterInfo) {
                monitorInfo.setRegDate(logFilterInfo.getRegDate());
                monitorInfo.setRegUser(logFilterInfo.getRegUser());
            }
            Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
            log.info((Object)Messages.getMsg("ImportTool.MonitorID", objectArray));
            arrayList.add((LogFilterInfo)monitorInfo);
        }
        this.registerMonitorInfo(arrayList);
        log.info((Object)Messages.getMsg("ImportTool.Syslogng.End"));
    }

    @Override
    public MonitorInfo createMonitorInfo(ArrayList<String> arrayList) {
        LogFilterInfo logFilterInfo = new LogFilterInfo();
        this.createMonitorBase(arrayList, (MonitorInfo)logFilterInfo);
        this.createMonitorRule(arrayList.subList(3, 5), (MonitorInfo)logFilterInfo);
        this.createMonitorCheck(arrayList.subList(5, 7), (MonitorInfo)logFilterInfo);
        this.createMonitorNotify(arrayList.subList(7, 12), (MonitorInfo)logFilterInfo);
        this.createMonitorApplication(arrayList.subList(12, 13), (MonitorInfo)logFilterInfo);
        this.createMonitorMessages(arrayList.subList(13, 16), (MonitorInfo)logFilterInfo);
        this.createMonitorVaild(arrayList.subList(16, 17), (MonitorInfo)logFilterInfo);
        return logFilterInfo;
    }

    @Override
    protected void createMonitorBase(List<String> list, MonitorInfo monitorInfo) {
        LogFilterInfo logFilterInfo = (LogFilterInfo)monitorInfo;
        logFilterInfo.setOrderNo(Integer.parseInt(list.get(0)));
        logFilterInfo.setMonitorId(list.get(1));
        logFilterInfo.setDescription(list.get(2));
    }

    @Override
    protected void createMonitorRule(List<String> list, MonitorInfo monitorInfo) {
        monitorInfo.setCalendarId(list.get(0));
        monitorInfo.setFacilityId(list.get(1));
    }

    @Override
    protected void createMonitorCheck(List<String> list, MonitorInfo monitorInfo) {
        LogFilterInfo logFilterInfo = (LogFilterInfo)monitorInfo;
        logFilterInfo.setPattern(list.get(0));
        logFilterInfo.setProcessType(ProcessConstant.stringToType((String)list.get(1)));
    }

    protected void createMonitorMessages(List<String> list, MonitorInfo monitorInfo) {
        LogFilterInfo logFilterInfo = (LogFilterInfo)monitorInfo;
        logFilterInfo.setPriority(PriorityConstant.stringToType((String)list.get(0)));
        logFilterInfo.setMessageId(list.get(1));
        logFilterInfo.setMessage(list.get(2));
    }

    protected void registerMonitorInfo(ArrayList<LogFilterInfo> arrayList) {
        SyslogNGController syslogNGController = EjbConnectionManager.getConnectionManager().getMonitorSyslogNGController();
        try {
            syslogNGController.createMonitorRuleList(arrayList);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ImportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected LogFilterInfo checkMonitorList(String string, ArrayList<LogFilterInfo> arrayList) {
        if (arrayList instanceof ArrayList) {
            for (LogFilterInfo logFilterInfo : arrayList) {
                if (logFilterInfo.getMonitorId().compareTo(string) != 0) continue;
                return logFilterInfo;
            }
        }
        return null;
    }

    protected ArrayList<LogFilterInfo> getMonitorList() {
        SyslogNGController syslogNGController = EjbConnectionManager.getConnectionManager().getMonitorSyslogNGController();
        ArrayList arrayList = null;
        try {
            arrayList = syslogNGController.getFilterInfoList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ImportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

