/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.test.monitor;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.monitor.bean.ReportEventInfo;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.bean.NotifyRelationInfo;
import com.clustercontrol.notify.ejb.entity.MonitorStatusData;
import com.clustercontrol.notify.ejb.entity.NotifyHistoryData;
import com.clustercontrol.notify.monitor.ejb.entity.StatusInfoData;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import jp.co.intellilink.hinemos.test.util.Config;
import jp.co.intellilink.hinemos.test.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.test.util.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckResultMonitor {
    private Date fromDate;
    private Date toDate;
    private static Log log = LogFactory.getLog(CheckResultMonitor.class);

    public CheckResultMonitor(Date date, Date date2) {
        this.fromDate = date;
        this.toDate = date2;
    }

    public ArrayList<ArrayList<String>> createCheckResult(MonitorInfo monitorInfo) {
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.addAll(this.getFacilityIdList(monitorInfo));
        for (String string : arrayList2) {
            ArrayList<String> arrayList3 = new ArrayList<String>();
            arrayList3.add(monitorInfo.getMonitorId());
            arrayList3.add(string);
            arrayList3.addAll(this.checkStatus(monitorInfo, string));
            arrayList3.addAll(this.checkEvent(monitorInfo, string));
            arrayList3.addAll(this.checkNotify(monitorInfo, string));
            arrayList.add(arrayList3);
        }
        return arrayList;
    }

    protected ArrayList<String> getFacilityIdList(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (monitorInfo.getMonitorBlock() == 0) {
            arrayList.addAll(this.getNodeList(monitorInfo.getFacilityId()));
        } else {
            arrayList.add(monitorInfo.getFacilityId());
        }
        return arrayList;
    }

    protected ArrayList<String> checkStatus(MonitorInfo monitorInfo, String string) {
        ArrayList<StatusInfoData> arrayList;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string2 = "-";
        if (monitorInfo.getValid() == 0) {
            arrayList2.add(string2);
            return arrayList2;
        }
        String string3 = null;
        if (monitorInfo.getNotifyId() != null) {
            arrayList = monitorInfo.getNotifyId();
            for (int i = 0; i < arrayList.size(); ++i) {
                NotifyRelationInfo notifyRelationInfo = (NotifyRelationInfo)arrayList.get(i);
                if (notifyRelationInfo.getNotifyType() != 0) continue;
                string3 = notifyRelationInfo.getNotifyId();
                break;
            }
        }
        if (string3 != null) {
            string2 = "NG";
            arrayList = EjbConnectionManager.getConnectionManager().getStatus(string);
            for (StatusInfoData statusInfoData : arrayList) {
                if (statusInfoData.getMonitorId().compareTo(monitorInfo.getMonitorId()) != 0) continue;
                string2 = DateFormat.getDateTimeInstance().format(statusInfoData.getGenerationDate());
                if (statusInfoData.getExpirationFlg() != null && statusInfoData.getExpirationFlg() != 10) {
                    string2 = DateFormat.getDateTimeInstance().format(statusInfoData.getGenerationDate());
                }
                break;
            }
        } else {
            string2 = "-";
        }
        arrayList2.add(string2);
        return arrayList2;
    }

    protected ArrayList<String> checkEvent(MonitorInfo monitorInfo, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "-";
        String string3 = "-";
        String string4 = "-";
        String string5 = "-";
        if (monitorInfo.getValid() == 0) {
            arrayList.add(string2);
            arrayList.add(string3);
            arrayList.add(string4);
            arrayList.add(string5);
            return arrayList;
        }
        String string6 = null;
        if (monitorInfo.getNotifyId() != null) {
            Collection collection = monitorInfo.getNotifyId();
            for (int i = 0; i < collection.size(); ++i) {
                NotifyRelationInfo notifyRelationInfo = (NotifyRelationInfo)((ArrayList)collection).get(i);
                if (notifyRelationInfo.getNotifyType() != 1) continue;
                string6 = notifyRelationInfo.getNotifyId();
                break;
            }
        }
        if (string6 != null) {
            string2 = this.checkEventByPriority(monitorInfo, string, 3, this.fromDate, this.toDate);
            string3 = this.checkEventByPriority(monitorInfo, string, 2, this.fromDate, this.toDate);
            string4 = this.checkEventByPriority(monitorInfo, string, 0, this.fromDate, this.toDate);
            string5 = this.checkEventByPriority(monitorInfo, string, 1, this.fromDate, this.toDate);
        }
        arrayList.add(string2);
        arrayList.add(string3);
        arrayList.add(string4);
        arrayList.add(string5);
        return arrayList;
    }

    protected String checkEventByPriority(MonitorInfo monitorInfo, String string, int n, Date date, Date date2) {
        String string2 = "";
        ArrayList<ReportEventInfo> arrayList = EjbConnectionManager.getConnectionManager().getEvent(string, date, date2);
        Date date3 = null;
        if (arrayList == null) {
            return string2;
        }
        for (ReportEventInfo reportEventInfo : arrayList) {
            String string3 = reportEventInfo.getMonitorId();
            int n2 = PriorityConstant.stringToType((String)reportEventInfo.getPriority());
            if (string3.compareTo(monitorInfo.getMonitorId()) != 0 || n2 != n) continue;
            if (date3 instanceof Date) {
                if (!date3.before(reportEventInfo.getGenerationDate())) continue;
                date3 = reportEventInfo.getGenerationDate();
                continue;
            }
            date3 = reportEventInfo.getGenerationDate();
        }
        if (date3 instanceof Date) {
            string2 = DateFormat.getDateTimeInstance().format(date3);
        }
        return string2;
    }

    protected ArrayList<String> checkNotify(MonitorInfo monitorInfo, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "-";
        String string3 = "-";
        String string4 = "-";
        String string5 = "-";
        String string6 = "-";
        if (monitorInfo.getValid() == 0) {
            arrayList.add(string2);
            arrayList.add(string3);
            arrayList.add(string4);
            arrayList.add(string5);
            arrayList.add(string6);
            return arrayList;
        }
        if (monitorInfo.getNotifyId() != null) {
            Collection collection = monitorInfo.getNotifyId();
            for (int i = 0; i < collection.size(); ++i) {
                NotifyRelationInfo notifyRelationInfo = (NotifyRelationInfo)((ArrayList)collection).get(i);
                if (notifyRelationInfo.getNotifyType() == 0) {
                    string2 = this.checkNotifyInhibit(monitorInfo, notifyRelationInfo.getNotifyId(), string);
                    continue;
                }
                if (notifyRelationInfo.getNotifyType() == 1) {
                    string3 = this.checkNotifyInhibit(monitorInfo, notifyRelationInfo.getNotifyId(), string);
                    continue;
                }
                if (notifyRelationInfo.getNotifyType() == 2) {
                    string4 = this.checkNotifyInhibit(monitorInfo, notifyRelationInfo.getNotifyId(), string);
                    continue;
                }
                if (notifyRelationInfo.getNotifyType() == 3) {
                    string5 = this.checkNotifyInhibit(monitorInfo, notifyRelationInfo.getNotifyId(), string);
                    continue;
                }
                if (notifyRelationInfo.getNotifyType() != 4) continue;
                string6 = this.checkNotifyInhibit(monitorInfo, notifyRelationInfo.getNotifyId(), string);
            }
        }
        arrayList.add(string2);
        arrayList.add(string3);
        arrayList.add(string4);
        arrayList.add(string5);
        arrayList.add(string6);
        return arrayList;
    }

    protected String checkNotifyInhibit(MonitorInfo monitorInfo, String string, String string2) {
        String string3 = "NG";
        NotifyInfo notifyInfo = this.getNotify(string);
        if (notifyInfo.getValidFlg() == 1) {
            MonitorStatusData monitorStatusData = this.getMonitorStatus(monitorInfo, string2);
            if (monitorStatusData instanceof MonitorStatusData) {
                NotifyHistoryData notifyHistoryData;
                if (monitorStatusData.getCounter() >= (long)notifyInfo.getInitialCount().intValue() && (notifyHistoryData = this.getNotifyHistory(monitorInfo, string, string2)) instanceof NotifyHistoryData) {
                    if (Config.getConfig("notify.control.mode") == "0") {
                        if (notifyInfo.getRenotifyType() == 2) {
                            if (monitorStatusData.getLastUpdate().getTime() >= notifyHistoryData.getLastNotify().getTime()) {
                                string3 = "OK";
                            }
                        } else if (notifyInfo.getRenotifyType() == 0) {
                            if (monitorStatusData.getLastUpdate().getTime() >= notifyHistoryData.getLastNotify().getTime()) {
                                string3 = "OK";
                            }
                        } else {
                            Long l = monitorStatusData.getLastUpdate().getTime() - notifyHistoryData.getLastNotify().getTime();
                            Long l2 = (long)(notifyInfo.getRenotifyPeriod() * 60) * 1000L;
                            if (l <= l2 && l >= -l2.longValue()) {
                                string3 = "OK";
                            }
                        }
                    } else {
                        string3 = "OK";
                    }
                }
            } else {
                string3 = "OK";
            }
        } else {
            string3 = "OK";
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MonitorStatusData getMonitorStatus(MonitorInfo monitorInfo, String string) {
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.error((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)classNotFoundException);
            System.exit(14);
        }
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(Config.getConfig("DB.URL"), Config.getConfig("DB.USER"), Config.getConfig("DB.PASSWORD"));
        }
        catch (SQLException sQLException) {
            log.error((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)sQLException);
            System.exit(14);
        }
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM cc_monitor_status as a WHERE a.facility_id = ? and a.monitor_id = ?");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, monitorInfo.getMonitorId());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                MonitorStatusData monitorStatusData;
                MonitorStatusData monitorStatusData2 = monitorStatusData = new MonitorStatusData(resultSet.getString("facility_id"), resultSet.getString("plugin_id"), resultSet.getString("monitor_id"), Integer.valueOf(resultSet.getInt("priority")), resultSet.getTimestamp("last_update"), Long.valueOf(resultSet.getLong("counter")));
                return monitorStatusData2;
            }
            MonitorStatusData monitorStatusData = null;
            return monitorStatusData;
        }
        catch (SQLException sQLException) {
            log.error((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)sQLException);
            System.exit(14);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NotifyHistoryData getNotifyHistory(MonitorInfo monitorInfo, String string, String string2) {
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.error((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)classNotFoundException);
            System.exit(14);
        }
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(Config.getConfig("DB.URL"), Config.getConfig("DB.USER"), Config.getConfig("DB.PASSWORD"));
        }
        catch (SQLException sQLException) {
            log.error((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)sQLException);
            System.exit(14);
        }
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM cc_notify_history as a WHERE a.facility_id = ? and a.notify_id = ? and a.monitor_id = ?");
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, monitorInfo.getMonitorId());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                NotifyHistoryData notifyHistoryData;
                NotifyHistoryData notifyHistoryData2 = notifyHistoryData = new NotifyHistoryData(resultSet.getString("facility_id"), resultSet.getString("plugin_id"), resultSet.getString("monitor_id"), resultSet.getString("notify_id"), resultSet.getTimestamp("last_notify"));
                return notifyHistoryData2;
            }
            NotifyHistoryData notifyHistoryData = null;
            return notifyHistoryData;
        }
        catch (SQLException sQLException) {
            log.error((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)sQLException);
            System.exit(14);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return null;
    }

    protected NotifyInfo getNotify(String string) {
        return EjbConnectionManager.getConnectionManager().getNotifyId(string);
    }

    protected ArrayList<String> getNodeList(String string) {
        RepositoryController repositoryController = EjbConnectionManager.getConnectionManager().getRepositoryController();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (repositoryController.isNode(string)) {
                arrayList.add(string);
            } else {
                arrayList.addAll(repositoryController.getExecTargetFacilityIdList(string));
            }
        }
        catch (Exception exception) {
            log.error((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

