/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.test.maintenance;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.maintenance.bean.MaintenanceInfoDataImp;
import com.clustercontrol.maintenance.ejb.session.MaintenanceController;
import com.clustercontrol.monitor.bean.ReportEventInfo;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.bean.NotifyRelationInfo;
import com.clustercontrol.notify.monitor.ejb.entity.StatusInfoData;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import jp.co.intellilink.hinemos.test.util.Config;
import jp.co.intellilink.hinemos.test.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.test.util.Messages;
import jp.co.intellilink.hinemos.test.util.StringListComparator;
import jp.co.intellilink.hinemos.test.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckResultMaintenamce {
    private Date fromDate;
    private Date toDate;
    private static Log log = LogFactory.getLog(CheckResultMaintenamce.class);

    public CheckResultMaintenamce(Date date, Date date2) {
        this.fromDate = date;
        this.toDate = date2;
    }

    public void checkResult() {
        log.info((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.Maintenance.Start")));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getMaintenanceIdList();
        if (arrayList2 instanceof ArrayList) {
            for (ArrayList arrayList3 : arrayList2) {
                Object[] objectArray = new Object[]{(String)arrayList3.get(0)};
                log.info((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.MaintenanceID", objectArray)));
                MaintenanceInfoDataImp maintenanceInfoDataImp = this.getMaintenance((String)arrayList3.get(0));
                arrayList.addAll(this.createCheckResult(maintenanceInfoDataImp));
            }
            Collections.sort(arrayList, new StringListComparator(0));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Check.Output.Dir") + "/MAINTENANCE_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        log.info((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.Maintenance.End")));
    }

    public ArrayList<ArrayList<String>> createCheckResult(MaintenanceInfoDataImp maintenanceInfoDataImp) {
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(maintenanceInfoDataImp.getMaintenance_id());
        arrayList2.addAll(this.checkStatus(maintenanceInfoDataImp, "INTERNAL"));
        arrayList2.addAll(this.checkEvent(maintenanceInfoDataImp, "INTERNAL"));
        arrayList.add(arrayList2);
        return arrayList;
    }

    protected ArrayList<String> checkStatus(MaintenanceInfoDataImp maintenanceInfoDataImp, String string) {
        ArrayList<StatusInfoData> arrayList;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string2 = "-";
        if (maintenanceInfoDataImp.getValid_flg() == 0) {
            arrayList2.add(string2);
            return arrayList2;
        }
        String string3 = null;
        if (maintenanceInfoDataImp.getNotifyId() != null) {
            arrayList = maintenanceInfoDataImp.getNotifyId();
            for (int i = 0; i < arrayList.size(); ++i) {
                NotifyRelationInfo notifyRelationInfo = (NotifyRelationInfo)arrayList.get(i);
                if (notifyRelationInfo.getNotifyType() != 0) continue;
                string3 = notifyRelationInfo.getNotifyId();
                break;
            }
        }
        if (string3 != null) {
            string2 = "NG";
            arrayList = EjbConnectionManager.getConnectionManager().getStatus(string);
            for (StatusInfoData statusInfoData : arrayList) {
                if (statusInfoData.getMonitorId().compareTo(maintenanceInfoDataImp.getMaintenance_id()) != 0) continue;
                string2 = DateFormat.getDateTimeInstance().format(statusInfoData.getGenerationDate());
                if (statusInfoData.getExpirationFlg() != null && statusInfoData.getExpirationFlg() != 10) {
                    string2 = DateFormat.getDateTimeInstance().format(statusInfoData.getGenerationDate());
                }
                break;
            }
        } else {
            string2 = "-";
        }
        arrayList2.add(string2);
        return arrayList2;
    }

    protected ArrayList<String> checkEvent(MaintenanceInfoDataImp maintenanceInfoDataImp, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "-";
        String string3 = "-";
        String string4 = "-";
        String string5 = "-";
        if (maintenanceInfoDataImp.getValid_flg() == 0) {
            arrayList.add(string2);
            arrayList.add(string3);
            arrayList.add(string4);
            arrayList.add(string5);
            return arrayList;
        }
        String string6 = null;
        if (maintenanceInfoDataImp.getNotifyId() != null) {
            Collection collection = maintenanceInfoDataImp.getNotifyId();
            for (int i = 0; i < collection.size(); ++i) {
                NotifyRelationInfo notifyRelationInfo = (NotifyRelationInfo)((ArrayList)collection).get(i);
                if (notifyRelationInfo.getNotifyType() != 1) continue;
                string6 = notifyRelationInfo.getNotifyId();
                break;
            }
        }
        if (string6 != null) {
            string2 = this.checkEventByPriority(maintenanceInfoDataImp, string, 3, this.fromDate, this.toDate);
            string3 = this.checkEventByPriority(maintenanceInfoDataImp, string, 2, this.fromDate, this.toDate);
            string4 = this.checkEventByPriority(maintenanceInfoDataImp, string, 0, this.fromDate, this.toDate);
            string5 = this.checkEventByPriority(maintenanceInfoDataImp, string, 1, this.fromDate, this.toDate);
        }
        arrayList.add(string2);
        arrayList.add(string3);
        arrayList.add(string4);
        arrayList.add(string5);
        return arrayList;
    }

    protected String checkEventByPriority(MaintenanceInfoDataImp maintenanceInfoDataImp, String string, int n, Date date, Date date2) {
        String string2 = "";
        ArrayList<ReportEventInfo> arrayList = EjbConnectionManager.getConnectionManager().getEvent(string, date, date2);
        Date date3 = null;
        for (ReportEventInfo reportEventInfo : arrayList) {
            String string3 = reportEventInfo.getMonitorId();
            int n2 = PriorityConstant.stringToType((String)reportEventInfo.getPriority());
            if (string3.compareTo(maintenanceInfoDataImp.getMaintenance_id()) != 0 || n2 != n) continue;
            if (date3 instanceof Date) {
                if (!date3.before(reportEventInfo.getGenerationDate())) continue;
                date3 = reportEventInfo.getGenerationDate();
                continue;
            }
            date3 = reportEventInfo.getGenerationDate();
        }
        if (date3 instanceof Date) {
            string2 = DateFormat.getDateTimeInstance().format(date3);
        }
        return string2;
    }

    protected NotifyInfo getNotify(String string) {
        return EjbConnectionManager.getConnectionManager().getNotifyId(string);
    }

    protected MaintenanceInfoDataImp getMaintenance(String string) {
        MaintenanceController maintenanceController = EjbConnectionManager.getConnectionManager().getMaintenanceController();
        MaintenanceInfoDataImp maintenanceInfoDataImp = null;
        try {
            maintenanceInfoDataImp = maintenanceController.getMaintenanceInfo(string);
        }
        catch (Exception exception) {
            log.error((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
            System.exit(14);
        }
        return maintenanceInfoDataImp;
    }

    protected ArrayList getSchedule(String string) {
        MaintenanceController maintenanceController = EjbConnectionManager.getConnectionManager().getMaintenanceController();
        ArrayList arrayList = null;
        try {
            arrayList = maintenanceController.getSchedule(string);
        }
        catch (Exception exception) {
            log.error((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }

    protected ArrayList getMaintenanceIdList() {
        MaintenanceController maintenanceController = EjbConnectionManager.getConnectionManager().getMaintenanceController();
        ArrayList arrayList = null;
        try {
            arrayList = maintenanceController.getMaintenanceList();
        }
        catch (Exception exception) {
            log.error((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

