#!/bin/bash

# 
# Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License 
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# Hinemos Tools
#
# Hinemos Export Tool (Conf)
#   設定情報エクスポートツール実行スクリプト
# 
# @version 1.0.0
# @since 1.0.0
#

# load Script Configuration
DIR=`dirname $0`
. ${DIR}/lib/hinemos_tools.cfg

# load Hinemos Manager Configuration
. ${HINEMOS_CFG}

JBOSS_LIB=${JBOSS_HOME}/server/default/lib
HINEMOS_LIB=${HINEMOS_HOME}/lib

CLASSPATH=.:${DIR}
if [ ${HINEMOS_VERSION} = "3.0" ] ; then
	CLASSPATH=${CLASSPATH}:${DIR}/lib:${DIR}/lib/hinemos_tools.3.0.jar
elif [ ${HINEMOS_VERSION} = "3.1" ] ; then
	CLASSPATH=${CLASSPATH}:${DIR}/lib:${DIR}/lib/hinemos_tools.3.1.jar
elif [ ${HINEMOS_VERSION} = "3.2" ] ; then
	CLASSPATH=${CLASSPATH}:${DIR}/lib:${DIR}/lib/hinemos_tools.3.2.jar
else
	exit -1
fi

if [ ${HINEMOS_VERSION} = "3.0" ] || [ ${HINEMOS_VERSION} = "3.1" ] ; then
	CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/AccessControlEJB.jar:${HINEMOS_LIB}/NotifyEJB.jar
	CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/PingEJB.jar:${HINEMOS_LIB}/HttpEJB.jar
	CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/HinemosAgentEJB.jar:${HINEMOS_LIB}/ProcessEJB.jar
	CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/PerformanceEJB.jar:${HINEMOS_LIB}/PortEJB.jar
	CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/SnmpEJB.jar:${HINEMOS_LIB}/SqlEJB.jar
	CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/SnmpTrapEJB.jar:${HINEMOS_LIB}/SyslogNGEJB.jar
	CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/MaintenanceEJB.jar:${HINEMOS_LIB}/LogTransferEJB.jar
	CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/RepositoryEJB.jar:${HINEMOS_LIB}/JobManagementEJB.jar
	CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/CalendarEJB.jar
	CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/hinemos-commons.jar:${HINEMOS_LIB}/clustercontrol.jar
	CLASSPATH=${CLASSPATH}:${JBOSS_LIB}/quartz.jar:${JBOSS_LIB}/org.eclipse.jface_3.1.1.jar
elif [ ${HINEMOS_VERSION} = "3.2" ] ; then
	CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/HinemosCommon.jar:${HINEMOS_LIB}/HinemosIF.jar
	CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/quartz.jar:${HINEMOS_LIB}/org.eclipse.jface_3.1.1.jar
fi

CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/jbossall-client.jar:${HINEMOS_LIB}/commons-logging-1.1.jar

LOG4J=`find ${HINEMOS_LIB}/log4j-*.jar -printf %f`
CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/${LOG4J}

${JAVA_HOME}/bin/java ${OPT} -Dlogdir=${DIR} -classpath ${CLASSPATH} jp.co.intellilink.hinemos.export.ExportConf $* 2>/dev/null
RET=$?

#echo ${RET}
exit ${RET}
