/*
 
Copyright (C) 2008 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.hinemos.export.util;

import java.util.List;


/**
 * 2次元配列のデータ(文字列)をソートするクラス<BR>
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class StringListComparator implements java.util.Comparator{
	private int index = 0;
	
	public StringListComparator(int index){
		this.index = index;
	}
	
	/* (non-Javadoc)
	 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	 */
	public int compare(Object o1, Object o2){
		if (o1 instanceof List && o2 instanceof List) {
			String value1 = (String)((List)o1).get(index);
			String value2 = (String)((List)o2).get(index);
			return value1.compareTo(value2);
		}
		else
			return 0;
	}
}

