/*
 
Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.hinemos.export.conf.access;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;

import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.ejb.session.AccessController;
import com.clustercontrol.accesscontrol.factory.UserProperty;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.util.PropertyUtil;

/**
 * 通知情報を取得するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ExportAccess {
	
	// ログ出力
	private static Log log = LogFactory.getLog(ExportAccess.class);

    /**
     * ログ転送情報をExportする。<br>
     */
    public void exportAccess() {
    	log.info(Messages.getMsg("Accsess.Start", new String[]{Messages.getMsg("ExportTool.Export")}));
    	
    	//CSV出力配列を用意
    	ArrayList<ArrayList<String>> csvOutput = new ArrayList<ArrayList<String>>();
    	
    	//ユーザIDリスト取得
    	ArrayList idList = getAccessList();
    	
    	if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				ArrayList line = (ArrayList)itr.next();
				
				Object[] args = {(String)line.get(0)};
				log.info(Messages.getMsg("UserID", args));
				
				Property info = getAccess((String)line.get(0));
				csvOutput.add(createCsvFormat(info));
			}
			
			//ユーザIDでソート
			Collections.sort(csvOutput, new StringListComparator(0));
    	}
		
		SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HHmmss");
		WriteCsvFile.writeCsvFile(
				Config.getConfig("Export.Dir") + "/ACCESS_" + format.format(new Date()) + ".csv", 
				csvOutput);
		
		log.info(Messages.getMsg("Accsess.End", new String[]{Messages.getMsg("ExportTool.Export")}));
    }
    
    /**
	 * ユーザ情報をExportする。<br>
	 * 
	 * @param info ユーザ情報
	 * @return CSVフォーマット文字列
	 */
	public ArrayList<String> createCsvFormat(Property info) {
		ArrayList<String> csvFormat = new ArrayList<String>();
		ArrayList values = null;
		
		//ユーザID
		values = PropertyUtil.getPropertyValue(info, UserProperty.UID);
		csvFormat.add(getStringValue(values));
		//名前
		values = PropertyUtil.getPropertyValue(info, UserProperty.NAME);
		csvFormat.add(getStringValue(values));
		//説明
		values = PropertyUtil.getPropertyValue(info, UserProperty.DESCRIPTION);
		csvFormat.add(getStringValue(values));
		
		//リポジトリ-参照
		values = PropertyUtil.getPropertyValue(info, UserProperty.REPOSITORY_READ);
		csvFormat.add(getBooleanValue(values));
		//リポジトリ-設定
		values = PropertyUtil.getPropertyValue(info, UserProperty.REPOSITORY_WRITE);
		csvFormat.add(getBooleanValue(values));
		//アクセス-参照
		values = PropertyUtil.getPropertyValue(info, UserProperty.ACCESSCONTROL_READ);
		csvFormat.add(getBooleanValue(values));
		//アクセス-設定
		values = PropertyUtil.getPropertyValue(info, UserProperty.ACCESSCONTROL_WRITE);
		csvFormat.add(getBooleanValue(values));
		//監視管理-参照
		values = PropertyUtil.getPropertyValue(info, UserProperty.MONITOR_READ);
		csvFormat.add(getBooleanValue(values));
		//監視管理-設定
		values = PropertyUtil.getPropertyValue(info, UserProperty.MONITOR_WRITE);
		csvFormat.add(getBooleanValue(values));
		//ジョブ管理-参照
		values = PropertyUtil.getPropertyValue(info, UserProperty.JOBMANAGEMENT_READ);
		csvFormat.add(getBooleanValue(values));
		//ジョブ管理-設定
		values = PropertyUtil.getPropertyValue(info, UserProperty.JOBMANAGEMENT_WRITE);
		csvFormat.add(getBooleanValue(values));
		//ジョブ管理-実行
		values = PropertyUtil.getPropertyValue(info, UserProperty.JOBMANAGEMENT_EXECUTE);
		csvFormat.add(getBooleanValue(values));
		//性能管理-参照
		values = PropertyUtil.getPropertyValue(info, UserProperty.PERFORMANCE_READ);
		csvFormat.add(getBooleanValue(values));
		//性能管理-設定
		values = PropertyUtil.getPropertyValue(info, UserProperty.PERFORMANCE_WRITE);
		csvFormat.add(getBooleanValue(values));
		//性能管理-実行
		values = PropertyUtil.getPropertyValue(info, UserProperty.PERFORMANCE_EXECUTE);
		csvFormat.add(getBooleanValue(values));
		//一括制御-参照
		values = PropertyUtil.getPropertyValue(info, UserProperty.COLLECTIVERUN_READ);
		csvFormat.add(getBooleanValue(values));
		//一括制御-設定
		values = PropertyUtil.getPropertyValue(info, UserProperty.COLLECTIVERUN_WRITE);
		csvFormat.add(getBooleanValue(values));
		//一括制御-実行
		values = PropertyUtil.getPropertyValue(info, UserProperty.COLLECTIVERUN_EXECUTE);
		csvFormat.add(getBooleanValue(values));
		//syslog-ng監視-参照
		values = PropertyUtil.getPropertyValue(info, UserProperty.SYSLOGNG_MONITOR_READ);
		csvFormat.add(getBooleanValue(values));
		//syslog-ng監視-設定
		values = PropertyUtil.getPropertyValue(info, UserProperty.SYSLOGNG_MONITOR_WRITE);
		csvFormat.add(getBooleanValue(values));
		//PING監視-参照
		values = PropertyUtil.getPropertyValue(info, UserProperty.PING_MONITOR_READ);
		csvFormat.add(getBooleanValue(values));
		//PING監視-設定
		values = PropertyUtil.getPropertyValue(info, UserProperty.PING_MONITOR_WRITE);
		csvFormat.add(getBooleanValue(values));
		//サービス・ポート監視-参照
		values = PropertyUtil.getPropertyValue(info, UserProperty.PORT_MONITOR_READ);
		csvFormat.add(getBooleanValue(values));
		//サービス・ポート監視-設定
		values = PropertyUtil.getPropertyValue(info, UserProperty.PORT_MONITOR_WRITE);
		csvFormat.add(getBooleanValue(values));
		//プロセス監視-参照
		values = PropertyUtil.getPropertyValue(info, UserProperty.PROCESS_MONITOR_READ);
		csvFormat.add(getBooleanValue(values));
		//プロセス監視-設定
		values = PropertyUtil.getPropertyValue(info, UserProperty.PROCESS_MONITOR_WRITE);
		csvFormat.add(getBooleanValue(values));
		//SNMP監視-参照
		values = PropertyUtil.getPropertyValue(info, UserProperty.SNMP_MONITOR_READ);
		csvFormat.add(getBooleanValue(values));
		//SNMP監視-設定
		values = PropertyUtil.getPropertyValue(info, UserProperty.SNMP_MONITOR_WRITE);
		csvFormat.add(getBooleanValue(values));
		//SNMPTRAP監視-参照
		values = PropertyUtil.getPropertyValue(info, UserProperty.SNMPTRAP_MONITOR_READ);
		csvFormat.add(getBooleanValue(values));
		//SNMPTRAP監視-設定
		values = PropertyUtil.getPropertyValue(info, UserProperty.SNMPTRAP_MONITOR_WRITE);
		csvFormat.add(getBooleanValue(values));
		//SQL監視-参照
		values = PropertyUtil.getPropertyValue(info, UserProperty.SQL_MONITOR_READ);
		csvFormat.add(getBooleanValue(values));
		//SQL監視-設定
		values = PropertyUtil.getPropertyValue(info, UserProperty.SQL_MONITOR_WRITE);
		csvFormat.add(getBooleanValue(values));
		//エージェント監視-参照
		values = PropertyUtil.getPropertyValue(info, UserProperty.AGENT_MONITOR_READ);
		csvFormat.add(getBooleanValue(values));
		//エージェント監視-設定
		values = PropertyUtil.getPropertyValue(info, UserProperty.AGENT_MONITOR_WRITE);
		csvFormat.add(getBooleanValue(values));
		//HTTP監視-参照
		values = PropertyUtil.getPropertyValue(info, UserProperty.HTTP_MONITOR_READ);
		csvFormat.add(getBooleanValue(values));
		//HTTP監視-設定
		values = PropertyUtil.getPropertyValue(info, UserProperty.HTTP_MONITOR_WRITE);
		csvFormat.add(getBooleanValue(values));
		//ログ転送-参照
		values = PropertyUtil.getPropertyValue(info, UserProperty.LOG_TRANSFER_READ);
		csvFormat.add(getBooleanValue(values));
		//ログ転送-設定
		values = PropertyUtil.getPropertyValue(info, UserProperty.LOG_TRANSFER_WRITE);
		csvFormat.add(getBooleanValue(values));
		//カレンダ-参照
		values = PropertyUtil.getPropertyValue(info, UserProperty.CALENDAR_READ);
		csvFormat.add(getBooleanValue(values));
		//カレンダ-設定
		values = PropertyUtil.getPropertyValue(info, UserProperty.CALENDAR_WRITE);
		csvFormat.add(getBooleanValue(values));
		//通知-参照
		values = PropertyUtil.getPropertyValue(info, UserProperty.NOTIFY_READ);
		csvFormat.add(getBooleanValue(values));
		//通知-設定
		values = PropertyUtil.getPropertyValue(info, UserProperty.NOTIFY_WRITE);
		csvFormat.add(getBooleanValue(values));
		//重要度判定-参照
		values = PropertyUtil.getPropertyValue(info, UserProperty.PRIORITY_JUDGMENT_READ);
		csvFormat.add(getBooleanValue(values));
		//重要度判定-設定
		values = PropertyUtil.getPropertyValue(info, UserProperty.PRIORITY_JUDGMENT_WRITE);
		csvFormat.add(getBooleanValue(values));
		//メンテナンス-参照
		values = PropertyUtil.getPropertyValue(info, UserProperty.MAINTENANCE_READ);
		csvFormat.add(getBooleanValue(values));
		//メンテナンス-設定
		values = PropertyUtil.getPropertyValue(info, UserProperty.MAINTENANCE_WRITE);
		csvFormat.add(getBooleanValue(values));
		
		return csvFormat;
	}
	
	/**
	 * 配列から文字列を取得する。<br>
	 * 
	 * @param values 配列
	 * @return 文字列
	 */
	public String getStringValue(ArrayList values) {
		if(values.size() > 0 && values.get(0) instanceof String)
			return (String)values.get(0);
		else
			return "";
	}
	
	/**
	 * 配列からBooleanを取得し文字列に変換する。<br>
	 * 
	 * @param values 配列
	 * @return 文字列
	 */
	public String getBooleanValue(ArrayList values) {
		if(values.size() > 0 && values.get(0) instanceof Boolean)
			if(((Boolean)values.get(0)).booleanValue())
				return YesNoConstant.typeToString(YesNoConstant.TYPE_YES);
			else
				return YesNoConstant.typeToString(YesNoConstant.TYPE_NO);
		else
			return "";
	}
	
    /**
     * ユーザ情報を取得する。<br>
     * 
     * @param userId 取得対象のユーザID
     * @return ユーザ情報
     */
    protected Property getAccess(String userId) {

    	AccessController access = EjbConnectionManager.getConnectionManager().getAccessController();

    	Property info = null;
        try {
        	info = access.getUserProperty(userId, PropertyConstant.MODE_SHOW, Locale.getDefault());
        } catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
        }
        return info;
    }
    
    /**
     * ユーザIDリストを取得する。<br>
     * 
     * @return ユーザID一覧
     */
    protected ArrayList getAccessList() {

    	AccessController access = EjbConnectionManager.getConnectionManager().getAccessController();

        ArrayList records = null;
        try {
            records = access.getUserList();
        } catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
        return records;
    }
}