/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.check.conf;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import jp.co.intellilink.hinemos.util.EjbConnectionManager;

import com.clustercontrol.bean.MonitorBlockConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.notify.bean.NotifyRelationInfo;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.clustercontrol.repository.ejb.session.RepositoryControllerBean;

/**
 * 監視情報を取得するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class CheckMonitor {

	@SuppressWarnings("unchecked")
	private ArrayList idList = null;

	private int nodeTotalCount = 0;
	private int notifyTotalCount = 0;

	/**
	 * 監視項目数を取得する。<br>
	 * 
	 * @return 監視項目数
	 */
	public int getListCount() {
		if(idList instanceof ArrayList)
			return idList.size();
		else
			return 0;
	}

	/**
	 * 監視単位情報をExportする。<br>
	 * 
	 * @param monitorInfo 監視情報
	 * @return CSVフォーマット文字列
	 */
	public int getNodeCount(MonitorInfo monitorInfo) {
		int count = 0;

		if(monitorInfo.getMonitorBlock() == MonitorBlockConstant.TYPE_NODE){
			RepositoryController repository = 
				EjbConnectionManager.getConnectionManager().getRepositoryController();

			try {
				@SuppressWarnings("unchecked")
				ArrayList nodeList = 
					repository.getNodeList(monitorInfo.getFacilityId(), RepositoryControllerBean.ALL);
				count = nodeList.size();
			} catch (RemoteException e) {
			} catch (FinderException e) {
			} catch (NamingException e) {
			}
		}
		else
			count = 1;

		return count;
	}

	/**
	 * 通知数を取得する。<br>
	 * 
	 * @param monitorInfo 監視情報
	 * @return 通知数
	 */
	public int getNotifyCount(MonitorInfo monitorInfo) {
		int count = 0;

		if(monitorInfo.getNotifyId() != null){
			Collection<NotifyRelationInfo> notify = monitorInfo.getNotifyId();

			count = notify.size();
		}

		return count;
	}
	
	/**
	 * 出力ヘッダ配列を作成する<br>
	 * 
	 * @return 出力ヘッダ配列
	 */
	public static ArrayList<String> createOutputHeader() {
		ArrayList<String> output = new ArrayList<String>();
		output.add("MonitorType");
		output.add("MonitorCount");
		output.add("TotalNodeCount");
		output.add("ToralNotifyCount");

		return output;
	}

	/**
	 * 出力配列を作成する<br>
	 * 
	 * @return 出力配列
	 */
	public ArrayList<String> createOutput(String monitorType) {
		ArrayList<String> output = new ArrayList<String>();
		output.add(monitorType);
		output.add(String.valueOf(getListCount()));
		output.add(String.valueOf(getNodeTotalCount()));
		output.add(String.valueOf(getNotifyTotalCount()));

		return output;
	}

	/**
	 * 監視一覧情報を取得<br>
	 * 
	 * @return 監視一覧情報
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getIdList() {
		return idList;
	}

	/**
	 * 監視一覧情報を設定<br>
	 * 
	 * @param idList 監視一覧情報
	 */
	@SuppressWarnings("unchecked")
	public void setIdList(ArrayList idList) {
		this.idList = idList;
	}

	/**
	 * 合計ノード数を取得<br>
	 * 
	 * @return 合計ノード数
	 */
	public int getNodeTotalCount() {
		return nodeTotalCount;
	}

	/**
	 * 合計ノード数を設定<br>
	 * 
	 * @param nodeTotalCount 合計ノード数
	 */
	public void setNodeTotalCount(int nodeTotalCount) {
		this.nodeTotalCount = nodeTotalCount;
	}

	/**
	 * 合計ノード数にノード数を加算する<br>
	 * 
	 * @param nodeCount ノード数
	 */
	public void addNodeTotalCount(int nodeCount) {
		this.nodeTotalCount = this.nodeTotalCount + nodeCount;
	}

	/**
	 * 合計通知数を取得<br>
	 * 
	 * @return 合計通知数
	 */
	public int getNotifyTotalCount() {
		return notifyTotalCount;
	}

	/**
	 * 合計通知数を設定<br>
	 * 
	 * @param notifyTotalCount 合計通知数
	 */
	public void setNotifyTotalCount(int notifyTotalCount) {
		this.notifyTotalCount = notifyTotalCount;
	}

	/**
	 * 合計通知数に通知数を加算する<br>
	 * 
	 * @param notifyCount 通知数
	 */
	public void addNotifyTotalCount(int notifyCount) {
		this.notifyTotalCount = this.notifyTotalCount + notifyCount;
	}
}