/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.monitor;

import java.util.ArrayList;
import java.util.List;

import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.ReadCsvFile;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.hinemosagent.bean.AgentCheckInfo;
import com.clustercontrol.hinemosagent.ejb.session.MonitorAgentController;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;

/**
 * エージェント監視情報をインポートするクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ImportMonitorAgent extends ImportMonitorTruth {

	// ログ出力
	private static Log log = LogFactory.getLog(ImportMonitorAgent.class);

	@SuppressWarnings("unchecked")
	private ArrayList monitorList = null;
	
	private ArrayList<ArrayList<String>> monitorInfos = null;

	/**
	 * エージェント監視情報をインポートする。<br>
	 */
	public void importAgent() {
		log.info(Messages.getMsg("Agent.Start", new String[]{Messages.getMsg("ImportTool.Import")}));

		//エージェント監視情報のCSVファイルを読み込む
		monitorInfos = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/AGENT.csv");

		//エージェント監視項目リストを取得
		monitorList = getMonitorList();
		
		for(ArrayList<String> info : monitorInfos){
			MonitorInfo monitorInfo = createMonitorInfo(info);
			registerMonitorInfo(monitorInfo);
		}

		log.info(Messages.getMsg("Agent.End", new String[]{Messages.getMsg("ImportTool.Import")}));
	}

	/**
	 * 監視情報オブジェクトを作成する。<br>
	 * 
	 * @see jp.co.intellilink.hinemos.importtool.conf.monitor.ImportMonitor#createMonitorInfo(java.util.ArrayList)
	 */
	@Override
	protected MonitorInfo createMonitorInfo(ArrayList<String> info){
		MonitorInfo monitorInfo = new MonitorInfo();

		//監視基本情報
		createMonitorBase(info, monitorInfo);

		//監視条件情報
		createMonitorRule(info.subList(3, 5), monitorInfo);

		//監視情報
		createMonitorCheck(info.subList(5, 7), monitorInfo);

		//監視単位情報
		createMonitorBlock(info.subList(7, 8), monitorInfo);

		//監視判定情報
		createMonitorJudgement(info.subList(8, 11), monitorInfo);

		//監視通知情報
		createMonitorNotify(info.subList(11, 17), monitorInfo);

		//アプリケーション
		createMonitorApplication(info.subList(17, 18), monitorInfo);

		//有効/無効
		createMonitorVaild(info.subList(18, 19), monitorInfo);

		return monitorInfo;
	}

	/**
	 * エージェント監視情報を設定する。<br>
	 * 
	 * @param info 監視情報配列
	 * @param monitorInfo 監視情報オブジェクト
	 * 
	 * @see jp.co.intellilink.hinemos.importtool.conf.monitor.ImportMonitor#createMonitorCheck(java.util.List, com.clustercontrol.monitor.run.bean.MonitorInfo)
	 */
	@Override
	protected void createMonitorCheck(List<String> info, MonitorInfo monitorInfo) {
		AgentCheckInfo agentInfo = new AgentCheckInfo();

		//ジョブエージェント
		agentInfo.setCheckJobAgent(YesNoConstant.stringToType(info.get(0)));
		//ログ転送エージェント
		agentInfo.setCheckLogAgent(YesNoConstant.stringToType(info.get(1)));

		monitorInfo.setAgentCheckInfo(agentInfo);
		
		monitorInfo.setMonitorType(MonitorTypeConstant.TYPE_TRUTH);
		
		super.createMonitorCheck(info, monitorInfo);
	}

	/**
	 * 監視情報を登録する。<br>
	 * 
	 * @param info 監視情報オブジェクト
	 */
	protected void registerMonitorInfo(MonitorInfo info) {
		MonitorAgentController agent = EjbConnectionManager.getConnectionManager().getMonitorAgentController();

		try {
			@SuppressWarnings("unchecked")
			MonitorInfo list = checkMonitorList(info.getMonitorId(), monitorList);
			if(list instanceof MonitorInfo){
				info.setRegDate(list.getRegDate());
				info.setRegUser(list.getRegUser());
				
				Object[] args = {info.getMonitorId()};
				log.info(Messages.getMsg("MonitorID", args) + 
						" (" + Messages.getMsg("modify") + ")");

				agent.modifyAgent(info);
			}
			else{
				Object[] args = {info.getMonitorId()};
				log.info(Messages.getMsg("MonitorID", args) + 
						" (" + Messages.getMsg("add") + ")");

				agent.addAgent(info);
			}
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
	}

	/**
	 * 監視項目リストを取得する。<br>
	 * 
	 * @return 監視項目一覧
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList getMonitorList() {

		MonitorAgentController agent = EjbConnectionManager.getConnectionManager().getMonitorAgentController();

		ArrayList records = null;
		try {
			records = agent.getAgentList();
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return records;
	}
}