/*
 
Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.hinemos.importtool.util;

import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jnp.interfaces.NamingContext;

import com.clustercontrol.accesscontrol.ejb.session.AccessController;
import com.clustercontrol.accesscontrol.ejb.session.AccessControllerHome;
import com.clustercontrol.calendar.ejb.session.CalendarController;
import com.clustercontrol.calendar.ejb.session.CalendarControllerHome;
import com.clustercontrol.collectiverun.ejb.session.CollectiveRunController;
import com.clustercontrol.collectiverun.ejb.session.CollectiveRunControllerHome;
import com.clustercontrol.hinemosagent.ejb.session.MonitorAgentController;
import com.clustercontrol.hinemosagent.ejb.session.MonitorAgentControllerHome;
import com.clustercontrol.http.ejb.session.MonitorHttpController;
import com.clustercontrol.http.ejb.session.MonitorHttpControllerHome;
import com.clustercontrol.jobmanagement.ejb.session.JobController;
import com.clustercontrol.jobmanagement.ejb.session.JobControllerHome;
import com.clustercontrol.logtransfer.ejb.session.LogTransferController;
import com.clustercontrol.logtransfer.ejb.session.LogTransferControllerHome;
import com.clustercontrol.maintenance.ejb.session.MaintenanceController;
import com.clustercontrol.maintenance.ejb.session.MaintenanceControllerHome;
import com.clustercontrol.monitor.ejb.session.MonitorController;
import com.clustercontrol.monitor.ejb.session.MonitorControllerHome;
import com.clustercontrol.notify.ejb.session.NotifyController;
import com.clustercontrol.notify.ejb.session.NotifyControllerHome;
import com.clustercontrol.notify.mail.ejb.session.MailTemplateController;
import com.clustercontrol.notify.mail.ejb.session.MailTemplateControllerHome;
import com.clustercontrol.performance.ejb.session.CollectorController;
import com.clustercontrol.performance.ejb.session.CollectorControllerHome;
import com.clustercontrol.performance.monitor.ejb.session.MonitorPerfController;
import com.clustercontrol.performance.monitor.ejb.session.MonitorPerfControllerHome;
import com.clustercontrol.ping.ejb.session.MonitorPingController;
import com.clustercontrol.ping.ejb.session.MonitorPingControllerHome;
import com.clustercontrol.port.ejb.session.MonitorPortController;
import com.clustercontrol.port.ejb.session.MonitorPortControllerHome;
import com.clustercontrol.process.ejb.session.MonitorProcessController;
import com.clustercontrol.process.ejb.session.MonitorProcessControllerHome;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.clustercontrol.repository.ejb.session.RepositoryControllerHome;
import com.clustercontrol.snmp.ejb.session.MonitorSnmpController;
import com.clustercontrol.snmp.ejb.session.MonitorSnmpControllerHome;
import com.clustercontrol.snmptrap.ejb.session.MonitorSnmpTrapController;
import com.clustercontrol.snmptrap.ejb.session.MonitorSnmpTrapControllerHome;
import com.clustercontrol.sql.ejb.session.MonitorSqlController;
import com.clustercontrol.sql.ejb.session.MonitorSqlControllerHome;
import com.clustercontrol.syslogng.ejb.session.SyslogNGController;
import com.clustercontrol.syslogng.ejb.session.SyslogNGControllerHome;

/**
 * EJBとのコネクションを管理するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class EjbConnectionManager {
	/** シングルトン用インスタンス。 */
	private static EjbConnectionManager m_instance = null;
	/** コンテキスト。 */
	private NamingContext m_ctx = null;
	// ログ出力
	private static Log log = LogFactory.getLog(EjbConnectionManager.class);
	
	private EjbConnectionManager() {

	}

	/**
	 * 本クラスのインスタンスを返します。<br>
	 * 
	 * @return 唯一のインスタンス
	 */
	public static EjbConnectionManager getConnectionManager() {
		if (m_instance == null) {
			m_instance = new EjbConnectionManager();
		}
		return m_instance;
	}

	/**
	 * 通知機能 SessionBean のインスタンスを返します。<br>
	 * 
	 * @return 通知機能 SessionBean
	 */
	public synchronized NotifyController getNotifyController() {
		try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
		} catch (NamingException e) {
			return null;
		}

		NotifyControllerHome home;
		try {
			home = (NotifyControllerHome) m_ctx
			.lookup(NotifyControllerHome.JNDI_NAME);
			return home.create();
		} catch (NamingException e) {
		} catch (RemoteException e) {
		} catch (CreateException e) {
		}
		m_ctx = null;
		return null;
	}
	
	/**
	 * エージェント監視機能 SessionBean のインスタンスを返します。<br>
	 * 
	 * @return エージェント監視機能 SessionBean
	 */
    public synchronized MonitorAgentController getMonitorAgentController() {
        try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
        } catch (NamingException e) {
            return null;
        }

        MonitorAgentControllerHome home;
        try {
            home = (MonitorAgentControllerHome) m_ctx
                    .lookup(MonitorAgentControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
    
	/**
	 * HTTP監視機能 SessionBean のインスタンスを返します。<br>
	 * 
	 * @return HTTP監視機能 SessionBean
	 */
	public synchronized MonitorHttpController getMonitorHttpController() {
		try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
		} catch (NamingException e) {
			return null;
		}
		
		MonitorHttpControllerHome home;
		try {
			home = (MonitorHttpControllerHome) m_ctx
			.lookup(MonitorHttpControllerHome.JNDI_NAME);
			return home.create();
		} catch (NamingException e) {
		} catch (RemoteException e) {
		} catch (CreateException e) {
		}
		m_ctx = null;
		return null;
	}
	
	/**
	 * Ping監視機能 SessionBean のインスタンスを返します。<br>
	 * 
	 * @return Ping監視機能 SessionBean
	 */
    public synchronized MonitorPingController getMonitorPingController() {
		try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
		} catch (NamingException e) {
			return null;
		}

        MonitorPingControllerHome home;
        try {
            home = (MonitorPingControllerHome) m_ctx
                    .lookup(MonitorPingControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
    
	/**
	 * サービス・ポート監視機能 SessionBean のインスタンスを返します。<br>
	 * 
	 * @return サービス・ポート監視機能 SessionBean
	 */
    public synchronized MonitorPortController getMonitorPortController() {
        try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
        } catch (NamingException e) {
            return null;
        }

        MonitorPortControllerHome home;
        try {
            home = (MonitorPortControllerHome) m_ctx
                    .lookup(MonitorPortControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
    
	/**
	 * SNMP監視機能 SessionBean のインスタンスを返します。<br>
	 * 
	 * @return SNMP監視機能 SessionBean
	 */   
    public synchronized MonitorSnmpController getMonitorSnmpController() {
        try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
        } catch (NamingException e) {
            return null;
        }

        MonitorSnmpControllerHome home;
        try {
            home = (MonitorSnmpControllerHome) m_ctx
                    .lookup(MonitorSnmpControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
    
	/**
	 * プロセス監視機能 SessionBean のインスタンスを返します。<br>
	 * 
	 * @return プロセス監視機能 SessionBean
	 */
    public synchronized MonitorProcessController getMonitorProcessController() {
        try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
        } catch (NamingException e) {
            return null;
        }

        MonitorProcessControllerHome home;
        try {
            home = (MonitorProcessControllerHome) m_ctx
                    .lookup(MonitorProcessControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
    
	/**
	 * リソース監視機能 SessionBean のインスタンスを返します。<br>
	 * 
	 * @return リソース監視機能 SessionBean
	 */
    public synchronized MonitorPerfController getMonitorPerfController() {  	
    	try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
        } catch (NamingException e) {
            return null;
        }
    	
        MonitorPerfControllerHome home;
        try {
            home = (MonitorPerfControllerHome) m_ctx
                    .lookup(MonitorPerfControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        	e.printStackTrace();
        } catch (RemoteException e) {
        	e.printStackTrace();
        } catch (CreateException e) {
        	e.printStackTrace();
        }
        m_ctx = null;
        return null;
    }
    
	/**
	 * SQL監視機能 SessionBean のインスタンスを返します。<br>
	 * 
	 * @return SQL監視機能 SessionBean
	 */
    public synchronized MonitorSqlController getMonitorSqlController() {
        try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
        } catch (NamingException e) {
            return null;
        }

        MonitorSqlControllerHome home;
        try {
            home = (MonitorSqlControllerHome) m_ctx
                    .lookup(MonitorSqlControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
    
	/**
	 * SNMPTRAP監視機能 SessionBean のインスタンスを返します。<br>
	 * 
	 * @return SNMPTRAP監視機能 SessionBean
	 */
    public synchronized MonitorSnmpTrapController getMonitorSnmpTrapController() {
        try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
        } catch (NamingException e) {
            return null;
        }

        MonitorSnmpTrapControllerHome home;
        try {
            home = (MonitorSnmpTrapControllerHome) m_ctx
                    .lookup(MonitorSnmpTrapControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        	e.printStackTrace();
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
    
    /**
     * syslog-ng監視機能 SessionBean のインスタンスを返します。<BR>
	 * 
	 * @return syslog-ng監視機能 SessionBean
     */
    public synchronized SyslogNGController getMonitorSyslogNGController() {
        try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
        } catch (NamingException e) {
            return null;
        }

        SyslogNGControllerHome home;
        try {
            home = (SyslogNGControllerHome) m_ctx
                    .lookup(SyslogNGControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
    
    /**
     * メンテナンス機能 SessionBean のインスタンスを返します。<BR>
	 * 
	 * @return メンテナンス機能 SessionBean
     */
    public synchronized MaintenanceController getMaintenanceController() {
        try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
        } catch (NamingException e) {
            return null;
        }

        MaintenanceControllerHome home;
        try {
            home = (MaintenanceControllerHome) m_ctx
                    .lookup(MaintenanceControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
    
    /**
     * ログ転送機能 SessionBean のインスタンスを返します。<BR>
	 * 
	 * @return ログ転送機能 SessionBean
     */
    public synchronized LogTransferController getLogTransferController() {
        try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
        } catch (NamingException e) {
            return null;
        }

        LogTransferControllerHome home;
        try {
            home = (LogTransferControllerHome) m_ctx
                    .lookup(LogTransferControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
    
    /**
     * メールテンプレート機能 SessionBean のインスタンスを返します。<BR>
	 * 
	 * @return メールテンプレート機能 SessionBean
     */
    public synchronized MailTemplateController getMailTemplateController() {
        try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
        } catch (NamingException e) {
            return null;
        }

        MailTemplateControllerHome home;
        try {
            home = (MailTemplateControllerHome) m_ctx
                    .lookup(MailTemplateControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
    
    /**
     * 性能管理機能 SessionBean のインスタンスを返します。<BR>
	 * 
	 * @return 性能管理機能 SessionBean
     */
    public synchronized CollectorController getCollectorController() {
        try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
        } catch (NamingException e) {
            return null;
        }

        CollectorControllerHome home;
        try {
            home = (CollectorControllerHome) m_ctx
                    .lookup(CollectorControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
    
	/**
	 * アクセス機能 SessionBean のインスタンスを返します。<BR>
	 * 
	 * @return アクセス機能 SessionBean
	 */
    public synchronized AccessController getAccessController() {
        try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
        } catch (NamingException e) {
            return null;
        }

        AccessControllerHome home;
        try {
            home = (AccessControllerHome) m_ctx
                    .lookup(AccessControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
    
	/**
	 * リポジトリ機能 SessionBean のインスタンスを返します。<BR>
	 * 
	 * @return リポジトリ機能 SessionBean
	 */
    public synchronized RepositoryController getRepositoryController() {
        try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
        } catch (NamingException e) {
            return null;
        }

        RepositoryControllerHome home;
        try {
            home = (RepositoryControllerHome) m_ctx
                    .lookup(RepositoryControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
    
	/**
	 * ジョブ管理機能 SessionBean のインスタンスを返します。<BR>
	 * 
	 * @return ジョブ管理機能 SessionBean
	 */
	public synchronized JobController getJobController() {
		try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
		} catch (NamingException e) {
			return null;
		}
		
		JobControllerHome home;
		try {
			home = (JobControllerHome)m_ctx.lookup(JobControllerHome.JNDI_NAME);
			return home.create();
		} catch (NamingException e) {
			log.error("", e);
		} catch (RemoteException e) {
			log.error("", e);
		} catch (CreateException e) {
			log.error("", e);
		}
		m_ctx = null;
		return null;
	}
	
	/**
	 * 監視管理機能 SessionBean のインスタンスを返します。<BR>
	 * 
	 * @return 監視管理機能 SessionBean
	 */
	public synchronized MonitorController getMonitorController() {
		try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
		} catch (NamingException e) {
			return null;
		}

		MonitorControllerHome home;
		try {
			home = (MonitorControllerHome) m_ctx
			.lookup(MonitorControllerHome.JNDI_NAME);
			return home.create();
		} catch (NamingException e) {
		} catch (RemoteException e) {
		} catch (CreateException e) {
		}
		m_ctx = null;
		return null;
	}
	
	/**
	 * カレンダ機能 SessionBean のインスタンスを返します。<BR>
	 * 
	 * @return カレンダ機能 SessionBean
	 */
    public synchronized CalendarController getCalendarController() {
        try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
        } catch (NamingException e) {
            return null;
        }

        CalendarControllerHome home;
        try {
            home = (CalendarControllerHome) m_ctx
                    .lookup(CalendarControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
	
	/**
	 * 一括制御機能 SessionBean のインスタンスを返します。<BR>
	 * 
	 * @return 一括制御機能 SessionBean
	 */
    public synchronized CollectiveRunController getCollectiveRunController() {
        try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
        } catch (NamingException e) {
            return null;
        }

        CollectiveRunControllerHome home;
        try {
            home = (CollectiveRunControllerHome) m_ctx
                    .lookup(CollectiveRunControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
}