/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.monitor;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.ejb.DuplicateKeyException;

import jp.co.intellilink.hinemos.importtool.util.Config;
import jp.co.intellilink.hinemos.importtool.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.importtool.util.Messages;
import jp.co.intellilink.hinemos.importtool.util.ReadCsvFile;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.http.bean.MonitorHttpInfo;
import com.clustercontrol.http.ejb.session.MonitorHttpController;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTabelDefine;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;

/**
 * HTTP監視情報をインポートするクラス<br>
 * 
 * @version 1.1.0
 * @since 1.1.0
 */
/**
 * @author Administrator
 *
 */
public class ImportMonitorHttp extends ImportMonitorNumeric {

	// ログ出力
	private static Log log = LogFactory.getLog(ImportMonitorHttp.class);

	@SuppressWarnings("unchecked")
	private ArrayList monitorList = null;
	
	private ArrayList<ArrayList<String>> monitorInfos = null;

	/**
	 * HTTP監視情報を作成する。<br>
	 */
	public void importHttp() {
		log.info(Messages.getMsg("ImportTool.Http.Start"));

		//HTTP監視情報のCSVファイルを読み込む
		monitorInfos = ReadCsvFile.readCsvFile(Config.getConfig("Input.Dir.Conf") + "/HTTP.csv");

		//監視項目リスト取得
		monitorList = getMonitorList();

		for(ArrayList<String> info : monitorInfos){
			MonitorInfo monitorInfo = createMonitorInfo(info);
			registerMonitorInfo(monitorInfo);
		}

		log.info(Messages.getMsg("ImportTool.Http.End"));
	}

	/**
	 * 監視情報オブジェクトを作成する。<br>
	 * 
	 * @see jp.co.intellilink.hinemos.importtool.conf.monitor.ImportMonitor#createMonitorInfo(java.util.ArrayList)
	 */
	@Override
	protected MonitorInfo createMonitorInfo(ArrayList<String> info){
		MonitorInfo monitorInfo = new MonitorInfo();

		//監視基本情報
		createMonitorBase(info, monitorInfo);

		//監視条件情報
		createMonitorRule(info.subList(3, 5), monitorInfo);

		//監視情報
		createMonitorCheck(info.subList(5, 7), monitorInfo);

		//監視判定情報
		createMonitorJudgement(info.subList(7, 12), monitorInfo);

		//監視通知情報
		createMonitorNotify(info.subList(12, 17), monitorInfo);

		//アプリケーション
		createMonitorApplication(info.subList(17, 18), monitorInfo);

		//有効/無効
		createMonitorVaild(info.subList(18, 19), monitorInfo);

		return monitorInfo;
	}

	/**
	 * エージェント監視情報を設定する。<br>
	 * 
	 * @param info 監視情報配列
	 * @param monitorInfo 監視情報オブジェクト
	 * 
	 * @see jp.co.intellilink.hinemos.importtool.conf.monitor.ImportMonitor#createMonitorCheck(java.util.List, com.clustercontrol.monitor.run.bean.MonitorInfo)
	 */
	@Override
	protected void createMonitorCheck(List<String> info, MonitorInfo monitorInfo) {
		MonitorHttpInfo httpInfo = new MonitorHttpInfo();

		//URL
		httpInfo.setRequestUrl(info.get(0));
		//タイムアウト
		httpInfo.setTimeout(Integer.parseInt(info.get(1)));

		monitorInfo.setCheckInfo(httpInfo);
		
		monitorInfo.setMonitorType(MonitorTypeConstant.TYPE_NUMERIC);

		super.createMonitorCheck(info, monitorInfo);
	}

	/**
	 * 監視情報を登録する。<br>
	 * 
	 * @param info 監視情報オブジェクト
	 */
	protected void registerMonitorInfo(MonitorInfo info) {
		MonitorHttpController http = EjbConnectionManager.getConnectionManager().getMonitorHttpController();

		try {
			@SuppressWarnings("unchecked")
			ArrayList list = checkMonitorList(info.getMonitorId(), monitorList);
			if(list instanceof ArrayList){
				Date createTime = (Date)list.get(MonitorTabelDefine.CREATE_TIME);
				String createUser = (String)list.get(MonitorTabelDefine.CREATE_USER);
				info.setRegDate(new Timestamp(createTime.getTime()));
				info.setRegUser(createUser);

				Object[] args = {info.getMonitorId()};
				log.info(Messages.getMsg("ImportTool.MonitorID", args) + 
						" (" + Messages.getMsg("modify") + ")");

				http.modifyHttp(info);
			}
			else{
				Object[] args = {info.getMonitorId()};
				log.info(Messages.getMsg("ImportTool.MonitorID", args) + 
						" (" + Messages.getMsg("add") + ")");

				http.addHttp(info);
			}
		} catch (DuplicateKeyException e) {
			String args[] = {info.getMonitorId()};
			log.error(Messages.getMsg("ImportTool.Common.1", args));
			System.exit(20);
		} catch (Exception e) {
			log.error(Messages.getMsg("ImportTool.ConnectManagerFailed"), e);
			System.exit(14);
		}
	}

	/**
	 * 監視項目リストを取得する。<br>
	 * 
	 * @return 監視項目一覧
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList getMonitorList() {

		MonitorHttpController http = EjbConnectionManager.getConnectionManager().getMonitorHttpController();

		ArrayList records = null;
		try {
			records = http.getHttpList();
		} catch (Exception e) {
			log.error(Messages.getMsg("ImportTool.ConnectManagerFailed"), e);
			System.exit(14);
		}
		return records;
	}
}