/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.repository;

import java.util.ArrayList;
import java.util.Locale;

import jp.co.intellilink.hinemos.importtool.util.Config;
import jp.co.intellilink.hinemos.importtool.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.importtool.util.Messages;
import jp.co.intellilink.hinemos.importtool.util.ReadCsvFile;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.repository.ejb.session.RepositoryController;

/**
 * スコープへのノード割り当て情報をインポートするクラス<br>
 * 
 * @version 1.1.0
 * @since 1.1.0
 */
public class ImportNodeScope {

	// ログ出力
	private static Log log = LogFactory.getLog(ImportNodeScope.class);

	private ArrayList<ArrayList<String>> nodeScopeInfos = null;

	/**
	 * スコープへのノード割り当て情報をインポートする。<br>
	 */
	public void importNodeScope() {
		log.info(Messages.getMsg("ImportTool.NodeScope.Start"));

		//スコープへのノード割り当て情報のCSVファイルを読み込む
		nodeScopeInfos = ReadCsvFile.readCsvFile(Config.getConfig("Input.Dir.Conf") + "/NODE_SCOPE.csv");

		//ノード割り当て解除
		deleteNodeScope(getFacilityTree());

		for(ArrayList<String> info : nodeScopeInfos){
			registerNodeScopeInfo(info.get(0), new String[]{info.get(1)});
		}

		log.info(Messages.getMsg("ImportTool.NodeScope.End"));
	}

	/**
	 * スコープへのノード割り当て情報削除（再帰呼び出し）
	 * 
	 * @param treeItem
	 */
	public void deleteNodeScope(FacilityTreeItem treeItem) {

		//子ツリーを取得する
		if (treeItem.getData() instanceof FacilityInfo){
			FacilityInfo info = treeItem.getData();
			if(info.getType() == FacilityConstant.TYPE_NODE 
					&& info.getFacilityId() != null 
					&& info.getFacilityId().compareTo("") != 0){
				String parentFacilityId = "";
				if(treeItem.getParent() != null){
					if (treeItem.getParent().getData() instanceof FacilityInfo){
						FacilityInfo parentInfo = treeItem.getParent().getData();
						if(parentInfo.getFacilityId() != null && parentInfo.getFacilityId().compareTo("") != 0){
							parentFacilityId = parentInfo.getFacilityId();
						}
					}
				}
				releaseNodeScope(parentFacilityId, new String[]{info.getFacilityId()});
			}
		}

		FacilityTreeItem[] childrenTreeItem = treeItem.getChildren();
		for (FacilityTreeItem childTreeItem : childrenTreeItem) {
			deleteNodeScope(childTreeItem);
		}
	}

	/**
	 * スコープへのノード割り当て情報を登録する。<br>
	 * 
	 * @param parentFacilityId 親ファシリティID
	 * @param facilityIdList ノードファシリティIDリスト
	 */
	protected void registerNodeScopeInfo(String parentFacilityId, String[] facilityIdList) {

		RepositoryController repository = EjbConnectionManager.getConnectionManager().getRepositoryController();

		try {
			if(facilityIdList.length > 0){
				Object[] args = {parentFacilityId, facilityIdList[0]};
				log.info(Messages.getMsg("ImportTool.Repository.2", args) + 
						" (" + Messages.getMsg("add") + ")");

				repository.assignNodeScope(parentFacilityId, facilityIdList);
			}
		} catch (Exception e) {
			log.error(Messages.getMsg("ImportTool.ConnectManagerFailed"), e);
			System.exit(14);
		}
	}

	/**
	 * スコープへのノード割り当てを解除する。<br>
	 * 
	 * @param parentFacilityId 親ファシリティID
	 * @param facilityIdList ノードファシリティIDリスト
	 */
	protected void releaseNodeScope(String parentFacilityId, String[] facilityIdList) {

		RepositoryController repository = EjbConnectionManager.getConnectionManager().getRepositoryController();

		try {
			if(facilityIdList.length > 0){
				Object[] args = {parentFacilityId, facilityIdList[0]};
				log.info(Messages.getMsg("ImportTool.Repository.2", args) + 
						" (" + Messages.getMsg("delete") + ")");

				repository.releaseNodeScope(parentFacilityId, facilityIdList);
			}
		} catch (Exception e) {
			log.error(Messages.getMsg("ImportTool.ConnectManagerFailed"), e);
			System.exit(14);
		}
	}

	/**
	 * ファシリティツリーを取得する。<br>
	 * 
	 * @return ファシリティツリー
	 */
	protected FacilityTreeItem getFacilityTree() {

		RepositoryController repository = EjbConnectionManager.getConnectionManager().getRepositoryController();

		FacilityTreeItem facilityTree = null;
		try {
			facilityTree = repository.getFacilityTree(Locale.getDefault());
		} catch (Exception e) {
			log.error(Messages.getMsg("ImportTool.ConnectManagerFailed"), e);
			System.exit(14);
		}
		return facilityTree;
	}
}