/*

Copyright (C) 2008 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.monitor;

import java.util.ArrayList;
import java.util.Iterator;

import jp.co.intellilink.hinemos.importtool.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.importtool.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.hinemosagent.ejb.session.MonitorAgentController;
import com.clustercontrol.monitor.run.bean.MonitorInfo;

/**
 * エージェント監視情報の有効・無効を設定するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class OnOffMonitorAgent {

	// ログ出力
	private static Log log = LogFactory.getLog(OnOffMonitorAgent.class);

	/**
	 * エージェント監視情報の有効・無効を設定する<br>
	 */
	@SuppressWarnings("unchecked")
	public void changeValid(boolean valid) {
		log.info(Messages.getMsg("ImportTool.Agent.Start", new String[]{Messages.getMsg("ImportTool.Change.Valid")}));

		//監視項目リスト取得
		ArrayList idList = getAgentList();

		if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				ArrayList line = (ArrayList)itr.next();

				MonitorInfo info = getAgent((String)line.get(0));
				info.setValid(ValidConstant.booleanToType(valid));
				changeMonitorInfo(info);
			}
		}

		log.info(Messages.getMsg("ImportTool.Agent.End", new String[]{Messages.getMsg("ImportTool.Change.Valid")}));
	}

	/**
	 * 監視情報を変更する。<br>
	 * 
	 * @param info 監視情報オブジェクト
	 */
	protected void changeMonitorInfo(MonitorInfo info) {
		MonitorAgentController agent = EjbConnectionManager.getConnectionManager().getMonitorAgentController();

		try {
			Object[] args = {info.getMonitorId()};
			log.info(Messages.getMsg("ImportTool.MonitorID", args) + 
					" (" + Messages.getMsg("modify") + ")");

			agent.modifyAgent(info);
		} catch (Exception e) {
			log.error(Messages.getMsg("ImportTool.ConnectManagerFailed"), e);
			System.exit(14);
		}
	}

	/**
	 * エージェント監視情報を取得する。<br>
	 * 
	 * @param monitorId 取得対象の監視項目ID
	 * @return エージェント監視情報
	 */
	protected MonitorInfo getAgent(String monitorId) {

		MonitorAgentController agent = EjbConnectionManager.getConnectionManager().getMonitorAgentController();

		MonitorInfo info = null;
		try {
			info = agent.getAgentInfo(monitorId);
		} catch (Exception e) {
			log.error(Messages.getMsg("ImportTool.ConnectManagerFailed"), e);
			System.exit(14);
		}
		return info;
	}

	/**
	 * 監視項目リストを取得する。<br>
	 * 
	 * @return 監視項目一覧
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList getAgentList() {

		MonitorAgentController agent = EjbConnectionManager.getConnectionManager().getMonitorAgentController();

		ArrayList records = null;
		try {
			records = agent.getAgentList();
		} catch (Exception e) {
			log.error(Messages.getMsg("ImportTool.ConnectManagerFailed"), e);
			System.exit(14);
		}
		return records;
	}
}