/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.access;

import java.util.ArrayList;
import java.util.Iterator;

import jp.co.intellilink.hinemos.importtool.util.Config;
import jp.co.intellilink.hinemos.importtool.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.importtool.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.ejb.session.AccessController;

/**
 * アクセス情報を削除するクラス<br>
 * 
 * @version 1.1.0
 * @since 1.1.0
 */
public class DeleteAccess {

	// ログ出力
	private static Log log = LogFactory.getLog(DeleteAccess.class);

	private static String loginUserId = Config.getConfig("Login.USER");

	/**
	 * アクセス情報を削除する。<br>
	 */
	@SuppressWarnings("unchecked")
	public void delete() {
		log.info(Messages.getMsg("ImportTool.Accsess.Start", new String[]{Messages.getMsg("ImportTool.Delete")}));

		//ユーザリスト取得
		ArrayList idList = getAccessList();

		if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				ArrayList line = (ArrayList)itr.next();

				deleteAccessInfo((String)line.get(0));
			}
		}

		log.info(Messages.getMsg("ImportTool.Accsess.End", new String[]{Messages.getMsg("ImportTool.Delete")}));
	}

	/**
	 * アクセス情報を削除する。<br>
	 * 
	 * @param userId ユーザID
	 */
	protected void deleteAccessInfo(String userId) {
		AccessController access = EjbConnectionManager.getConnectionManager().getAccessController();

		try {
			Object[] args = {userId};
			log.info(Messages.getMsg("ImportTool.UserID", args) + 
					" (" + Messages.getMsg("delete") + ")");

			if(loginUserId.equals(userId)){
				log.info(Messages.getMsg("ImportTool.Access.1"));
			}
			else{
				access.deleteUser(userId);
			}
		} catch (Exception e) {
			log.error(Messages.getMsg("ImportTool.ConnectManagerFailed"), e);
			System.exit(14);
		}
	}

	/**
	 * ユーザリストを取得する。<br>
	 * 
	 * @return ユーザ一覧
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList getAccessList() {

		AccessController access = EjbConnectionManager.getConnectionManager().getAccessController();

		ArrayList records = null;
		try {
			records = access.getUserList();
		} catch (Exception e) {
			log.error(Messages.getMsg("ImportTool.ConnectManagerFailed"), e);
			System.exit(14);
		}
		return records;
	}
}