/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.logtransfer;

import java.util.ArrayList;
import java.util.Iterator;

import jp.co.intellilink.hinemos.importtool.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.importtool.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.logtransfer.bean.LogTransferInfo;
import com.clustercontrol.logtransfer.ejb.session.LogTransferController;

/**
 * ログ転送情報の有効・無効を設定するクラス<br>
 * 
 * @version 1.1.0
 * @since 1.1.0
 */
public class ChangeValidLogTransfer {

	// ログ出力
	private static Log log = LogFactory.getLog(ChangeValidLogTransfer.class);

	/**
	 * ログ転送情報の有効・無効を設定する<br>
	 * 
	 * @param valid 有効/無効
	 */
	@SuppressWarnings("unchecked")
	public void changeValid(boolean valid) {
		log.info(Messages.getMsg("ImportTool.LogTransfer.Start", new String[]{Messages.getMsg("ImportTool.Change.Valid")}));

		//監視項目リスト取得
		ArrayList idList = getLogTransferList();

		if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				ArrayList line = (ArrayList)itr.next();

				LogTransferInfo info = getLogTransfer((String)line.get(0));
				info.setValid(ValidConstant.booleanToType(valid));
				changeLogTransferInfo(info);
			}
		}

		log.info(Messages.getMsg("ImportTool.LogTransfer.End", new String[]{Messages.getMsg("ImportTool.Change.Valid")}));
	}

	/**
	 * ログ転送情報の有効・無効を変更する。<br>
	 * 
	 * @param transferInfo ログ転送情報
	 */
	protected void changeLogTransferInfo(LogTransferInfo transferInfo) {

		LogTransferController transfer = EjbConnectionManager.getConnectionManager().getLogTransferController();

		try {
			Object[] args = {transferInfo.getTransferId()};
			log.info(Messages.getMsg("ImportTool.TransferID", args) + 
					" (" + Messages.getMsg("modify") + ")");

			transfer.modifyLogTransfer(transferInfo);
		} catch (Exception e) {
			log.error(Messages.getMsg("ImportTool.ConnectManagerFailed"), e);
			System.exit(14);
		}
	}

	/**
	 * ログ転送情報を取得する。<br>
	 * 
	 * @param transferId 取得対象の転送ID
	 * @return ログ転送情報
	 */
	protected LogTransferInfo getLogTransfer(String transferId) {

		LogTransferController transfer = EjbConnectionManager.getConnectionManager().getLogTransferController();

		LogTransferInfo info = null;
		try {
			info = transfer.getLogTransfer(transferId);
		} catch (Exception e) {
			log.error(Messages.getMsg("ExportTool.ConnectManagerFailed"), e);
			System.exit(14);
		}
		return info;
	}

	/**
	 * 転送項目リストを取得する。<br>
	 * 
	 * @return 転送項目一覧
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList getLogTransferList() {

		LogTransferController transfer = EjbConnectionManager.getConnectionManager().getLogTransferController();

		ArrayList records = null;
		try {
			records = transfer.getLogTransferList();
		} catch (Exception e) {
			log.error(Messages.getMsg("ImportTool.ConnectManagerFailed"), e);
			System.exit(14);
		}
		return records;
	}
}