#!/bin/bash

#
# Hinemos JMX Tool
#   JMX情報取得ツール起動スクリプト
# 
# @version 1.0.0
# @since 1.0.0
#

# load Script Configuration
DIR=`dirname $0`
. ${DIR}/lib/hinemos_jmx_tool.cfg

# load Hinemos Manager Configuration
. ${HINEMOS_CFG}

if [ -f $HINEMOS_JMX_TOOL_PID ] ; then
	read JMX_TOOL_PID < $HINEMOS_JMX_TOOL_PID
	ps -p $JMX_TOOL_PID -f | grep hinemos_jmx_tool > /dev/null && TMP=1
	if [ "$TMP" ] ; then
	        echo "JMXTool already started!"
        	exit 1
	fi
fi

JBOSS_DEPLOY=${JBOSS_HOME}/server/default/deploy
JBOSS_LIB=${JBOSS_HOME}/server/default/lib
HINEMOS_LIB=${HINEMOS_HOME}/lib

CLASSPATH=.:${DIR}:${DIR}/lib:${DIR}/lib/hinemos_jmx_tool.jar

CLASSPATH=${CLASSPATH}:${JBOSS_DEPLOY}/AccessControlEJB.jar:${HINEMOS_LIB}/clustercontrol.jar
CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/jbossall-client.jar:${HINEMOS_LIB}/commons-logging-1.1.jar

LOG4J=`find ${HINEMOS_LIB}/log4j*.jar -printf %f`
CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/${LOG4J}

${JAVA_HOME}/bin/java ${OPT} -Dlogdir=${DIR} -classpath ${CLASSPATH} jp.co.intellilink.hinemos.jmx.JMXTool $* 2>/dev/null &
RET=$?

echo $! > $HINEMOS_JMX_TOOL_PID  
echo "JMXTool started"