/*
 
Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.operation.logger;

import org.jboss.aop.Aspect;
import org.jboss.aop.Bind;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.joinpoint.MethodInvocation;

import com.clustercontrol.priority.bean.PriorityJudgmentInfo;

/**
 * 重要度判定機能 操作ログ出力クラス
 * 
 * @since 1.0.0
 * @version 1.0.0
 * @see jp.co.intellilink.operation.logger.Logger
 */
@Aspect (scope= Scope.PER_VM)
public class PriorityJudgment extends Logger {

	/**
	 * 重要度判定追加時のログ出力
	 * 
	 * @param invocation 
	 * @return invokeNext()の結果
	 * @throws Throwable
	 */
	@Bind (pointcut="execution(public void com.clustercontrol.priority.ejb.session.PriorityControllerBean->addPriorityJudgment(..))")
	public Object addPriorityJudgmentAdvice(MethodInvocation invocation) throws Throwable {
		Object result = invocation.invokeNext();

		String title = "[PriorityJudgment] Add";
		StringBuffer msg = new StringBuffer();

		Object[] args = ((MethodInvocation)invocation).getArguments();
		if(args.length > 0 && args[0] instanceof PriorityJudgmentInfo){
			PriorityJudgmentInfo info = (PriorityJudgmentInfo)args[0];
			msg.append(", JudgmentID=");
			msg.append(info.getJudgment_id());
		}

		outputLogMessage(title, msg.toString(), invocation);

		return result;
	}

	/**
	 * 重要度判定変更時のログ出力
	 * 
	 * @param invocation 
	 * @return invokeNext()の結果
	 * @throws Throwable
	 */
	@Bind (pointcut="execution(public void com.clustercontrol.priority.ejb.session.PriorityControllerBean->modifyPriorityJudgment(..))")
	public Object modifyPriorityJudgmentAdvice(MethodInvocation invocation) throws Throwable {
		Object result = invocation.invokeNext();

		String title = "[PriorityJudgment] Change";
		StringBuffer msg = new StringBuffer();

		Object[] args = ((MethodInvocation)invocation).getArguments();
		if(args.length > 0 && args[0] instanceof PriorityJudgmentInfo){
			PriorityJudgmentInfo info = (PriorityJudgmentInfo)args[0];
			msg.append(", JudgmentID=");
			msg.append(info.getJudgment_id());
		}

		outputLogMessage(title, msg.toString(), invocation);

		return result;
	}

	/**
	 * 重要度判定削除時のログ出力
	 * 
	 * @param invocation 
	 * @return invokeNext()の結果
	 * @throws Throwable
	 */
	@Bind (pointcut="execution(public void com.clustercontrol.priority.ejb.session.PriorityControllerBean->deletePriorityJudgment(..))")
	public Object deletePriorityJudgmentAdvice(MethodInvocation invocation) throws Throwable {
		Object result = invocation.invokeNext();

		String title = "[PriorityJudgment] Delete";
		StringBuffer msg = new StringBuffer();

		Object[] args = ((MethodInvocation)invocation).getArguments();
		if(args.length > 0 && args[0] instanceof String){
			msg.append(", JudgmentID=");
			msg.append((String)args[0]);
		}

		outputLogMessage(title, msg.toString(), invocation);

		return result;
	}
}
