/*
 
Copyright (C) 2008 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.hinemos.test.util;

import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.hinemosagent.ejb.session.MonitorAgentController;
import com.clustercontrol.hinemosagent.ejb.session.MonitorAgentControllerHome;
import com.clustercontrol.http.ejb.session.MonitorHttpController;
import com.clustercontrol.http.ejb.session.MonitorHttpControllerHome;
import com.clustercontrol.logtransfer.ejb.session.LogTransferController;
import com.clustercontrol.logtransfer.ejb.session.LogTransferControllerHome;
import com.clustercontrol.maintenance.ejb.session.MaintenanceController;
import com.clustercontrol.maintenance.ejb.session.MaintenanceControllerHome;
import com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfo;
import com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfoHome;
import com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfoPK;
import com.clustercontrol.notify.ejb.session.NotifyController;
import com.clustercontrol.notify.ejb.session.NotifyControllerHome;
import com.clustercontrol.notify.monitor.ejb.entity.EventLogHome;
import com.clustercontrol.notify.monitor.ejb.entity.StatusInfoHome;
import com.clustercontrol.performance.ejb.session.CollectorController;
import com.clustercontrol.performance.ejb.session.CollectorControllerHome;
import com.clustercontrol.performance.monitor.ejb.session.MonitorPerfController;
import com.clustercontrol.performance.monitor.ejb.session.MonitorPerfControllerHome;
import com.clustercontrol.ping.ejb.session.MonitorPingController;
import com.clustercontrol.ping.ejb.session.MonitorPingControllerHome;
import com.clustercontrol.port.ejb.session.MonitorPortController;
import com.clustercontrol.port.ejb.session.MonitorPortControllerHome;
import com.clustercontrol.process.ejb.session.MonitorProcessController;
import com.clustercontrol.process.ejb.session.MonitorProcessControllerHome;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.clustercontrol.repository.ejb.session.RepositoryControllerHome;
import com.clustercontrol.snmp.ejb.session.MonitorSnmpController;
import com.clustercontrol.snmp.ejb.session.MonitorSnmpControllerHome;
import com.clustercontrol.snmptrap.ejb.session.MonitorSnmpTrapController;
import com.clustercontrol.snmptrap.ejb.session.MonitorSnmpTrapControllerHome;
import com.clustercontrol.sql.ejb.session.MonitorSqlController;
import com.clustercontrol.sql.ejb.session.MonitorSqlControllerHome;
import com.clustercontrol.syslogng.ejb.session.SyslogNGController;
import com.clustercontrol.syslogng.ejb.session.SyslogNGControllerHome;

/**
 * EJBとのコネクションを管理するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class EjbConnectionManager {
	/** シングルトン用インスタンス。 */
	private static EjbConnectionManager m_instance = null;
	/** コンテキスト。 */
	private NamingContext m_ctx = null;

	private EjbConnectionManager() {

	}

	/**
	 * 本クラスのインスタンスを返します。<br>
	 * 
	 * @return 唯一のインスタンス
	 */
	public static EjbConnectionManager getConnectionManager() {
		if (m_instance == null) {
			m_instance = new EjbConnectionManager();
		}
		return m_instance;
	}

	/**
	 * 通知機能 SessionBean のインスタンスを返します。<br>
	 * 
	 * @return 通知機能 SessionBean
	 */
	public synchronized NotifyController getNotifyController() {
		try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
		} catch (NamingException e) {
			return null;
		}

		NotifyControllerHome home;
		try {
			home = (NotifyControllerHome) m_ctx
			.lookup(NotifyControllerHome.JNDI_NAME);
			return home.create();
		} catch (NamingException e) {
		} catch (RemoteException e) {
		} catch (CreateException e) {
		}
		m_ctx = null;
		return null;
	}
	
	/**
	 * エージェント監視機能 SessionBean のインスタンスを返します。<br>
	 * 
	 * @return エージェント監視機能 SessionBean
	 */
    public synchronized MonitorAgentController getMonitorAgentController() {
        try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
        } catch (NamingException e) {
            return null;
        }

        MonitorAgentControllerHome home;
        try {
            home = (MonitorAgentControllerHome) m_ctx
                    .lookup(MonitorAgentControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
    
	/**
	 * HTTP監視機能 SessionBean のインスタンスを返します。<br>
	 * 
	 * @return HTTP監視機能 SessionBean
	 */
	public synchronized MonitorHttpController getMonitorHttpController() {
		try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
		} catch (NamingException e) {
			return null;
		}
		
		MonitorHttpControllerHome home;
		try {
			home = (MonitorHttpControllerHome) m_ctx
			.lookup(MonitorHttpControllerHome.JNDI_NAME);
			return home.create();
		} catch (NamingException e) {
		} catch (RemoteException e) {
		} catch (CreateException e) {
		}
		m_ctx = null;
		return null;
	}
	
	/**
	 * Ping監視機能 SessionBean のインスタンスを返します。<br>
	 * 
	 * @return Ping監視機能 SessionBean
	 */
    public synchronized MonitorPingController getMonitorPingController() {
		try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
		} catch (NamingException e) {
			return null;
		}

        MonitorPingControllerHome home;
        try {
            home = (MonitorPingControllerHome) m_ctx
                    .lookup(MonitorPingControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
    
	/**
	 * サービス・ポート監視機能 SessionBean のインスタンスを返します。<br>
	 * 
	 * @return サービス・ポート監視機能 SessionBean
	 */
    public synchronized MonitorPortController getMonitorPortController() {
        try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
        } catch (NamingException e) {
            return null;
        }

        MonitorPortControllerHome home;
        try {
            home = (MonitorPortControllerHome) m_ctx
                    .lookup(MonitorPortControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
    
	/**
	 * SNMP監視機能 SessionBean のインスタンスを返します。<br>
	 * 
	 * @return SNMP監視機能 SessionBean
	 */   
    public synchronized MonitorSnmpController getMonitorSnmpController() {
        try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
        } catch (NamingException e) {
            return null;
        }

        MonitorSnmpControllerHome home;
        try {
            home = (MonitorSnmpControllerHome) m_ctx
                    .lookup(MonitorSnmpControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
    
	/**
	 * プロセス監視機能 SessionBean のインスタンスを返します。<br>
	 * 
	 * @return プロセス監視機能 SessionBean
	 */
    public synchronized MonitorProcessController getMonitorProcessController() {
        try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
        } catch (NamingException e) {
            return null;
        }

        MonitorProcessControllerHome home;
        try {
            home = (MonitorProcessControllerHome) m_ctx
                    .lookup(MonitorProcessControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
    
	/**
	 * リソース監視機能 SessionBean のインスタンスを返します。<br>
	 * 
	 * @return リソース監視機能 SessionBean
	 */
    public synchronized MonitorPerfController getMonitorPerfController() {  	
    	try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
        } catch (NamingException e) {
            return null;
        }
    	
        MonitorPerfControllerHome home;
        try {
            home = (MonitorPerfControllerHome) m_ctx
                    .lookup(MonitorPerfControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        	e.printStackTrace();
        } catch (RemoteException e) {
        	e.printStackTrace();
        } catch (CreateException e) {
        	e.printStackTrace();
        }
        m_ctx = null;
        return null;
    }
    
	/**
	 * SQL監視機能 SessionBean のインスタンスを返します。<br>
	 * 
	 * @return SQL監視機能 SessionBean
	 */
    public synchronized MonitorSqlController getMonitorSqlController() {
        try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
        } catch (NamingException e) {
            return null;
        }

        MonitorSqlControllerHome home;
        try {
            home = (MonitorSqlControllerHome) m_ctx
                    .lookup(MonitorSqlControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
    
	/**
	 * SNMPTRAP監視機能 SessionBean のインスタンスを返します。<br>
	 * 
	 * @return SNMPTRAP監視機能 SessionBean
	 */
    public synchronized MonitorSnmpTrapController getMonitorSnmpTrapController() {
        try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
        } catch (NamingException e) {
            return null;
        }

        MonitorSnmpTrapControllerHome home;
        try {
            home = (MonitorSnmpTrapControllerHome) m_ctx
                    .lookup(MonitorSnmpTrapControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        	e.printStackTrace();
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
    
    /**
     * syslog-ng監視機能 SessionBean のインスタンスを返します。<BR>
	 * 
	 * @return syslog-ng監視機能 SessionBean
     */
    public synchronized SyslogNGController getMonitorSyslogNGController() {
        try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
        } catch (NamingException e) {
            return null;
        }

        SyslogNGControllerHome home;
        try {
            home = (SyslogNGControllerHome) m_ctx
                    .lookup(SyslogNGControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
    
    /**
     * メンテナンス機能 SessionBean のインスタンスを返します。<BR>
	 * 
	 * @return メンテナンス機能 SessionBean
     */
    public synchronized MaintenanceController getMaintenanceController() {
        try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
        } catch (NamingException e) {
            return null;
        }

        MaintenanceControllerHome home;
        try {
            home = (MaintenanceControllerHome) m_ctx
                    .lookup(MaintenanceControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
    
    /**
     * ログ転送機能 SessionBean のインスタンスを返します。<BR>
	 * 
	 * @return ログ転送機能 SessionBean
     */
    public synchronized LogTransferController getLogTransferController() {
        try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
        } catch (NamingException e) {
            return null;
        }

        LogTransferControllerHome home;
        try {
            home = (LogTransferControllerHome) m_ctx
                    .lookup(LogTransferControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
    
    /**
     * 性能管理機能 SessionBean のインスタンスを返します。<BR>
	 * 
	 * @return 性能管理機能 SessionBean
     */
    public synchronized CollectorController getCollectorController() {
        try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
        } catch (NamingException e) {
            return null;
        }

        CollectorControllerHome home;
        try {
            home = (CollectorControllerHome) m_ctx
                    .lookup(CollectorControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
    
	/**
	 * リポジトリ機能 SessionBean のインスタンスを返します。<BR>
	 * 
	 * @return リポジトリ機能 SessionBean
	 */
    public synchronized RepositoryController getRepositoryController() {
        try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
        } catch (NamingException e) {
            return null;
        }

        RepositoryControllerHome home;
        try {
            home = (RepositoryControllerHome) m_ctx
                    .lookup(RepositoryControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
    
	/**
	 * 通知抑制情報 EnbtityBean のインスタンスを返します。<br>
	 * 
	 * @param notifyGroupId 通知グループID
	 * @param notifyId 通知ID
	 * @param facilityId ファシリティID
	 * @return 通知抑制情報 EnbtityBean
	 */
	public synchronized NotifyActionInhibitionInfo getNotifyActionInhibition(
			String notifyGroupId, String notifyId, String facilityId) {
		try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
		} catch (NamingException e) {
			return null;
		}

		NotifyActionInhibitionInfo info = null;
		try {
	    	// 抑制情報を取得
	    	try{
	    		NotifyActionInhibitionInfoHome home = (NotifyActionInhibitionInfoHome) m_ctx
                .lookup(NotifyActionInhibitionInfoHome.JNDI_NAME);
	            
		    	NotifyActionInhibitionInfoPK inhibitionPk = 
		    		new NotifyActionInhibitionInfoPK(notifyGroupId, notifyId, facilityId);
	    		info = home.findByPrimaryKey(inhibitionPk);
	    	}
	    	// 存在しない場合
	    	catch(FinderException e){
	    	}
			return info;
		} catch (NamingException e) {
			System.out.print(e);
		} catch (RemoteException e) {
		}
		m_ctx = null;
		return null;
	}
	
	/**
	 * イベント情報 EnbtityBean のインスタンスを返します。<br>
	 * 
	 * @param facilityId ファシリティID
	 * @param priority 重要度
	 * @param fromDate 出力日時（開始）
	 * @return イベント情報 EnbtityBean
	 */
	public synchronized Collection getEventByPriority(
			String facilityId, Integer priority, Date fromDate) {
		try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
		} catch (NamingException e) {
			return null;
		}

		Collection ct = null;
		try {
	    	try{
	    		EventLogHome home = (EventLogHome) m_ctx
                .lookup(EventLogHome.JNDI_NAME);
	    		
	    		String[] facilityIdList = {facilityId};
	    		Timestamp ftom = null;
	    		if(fromDate instanceof Date){
	    			ftom = new Timestamp(fromDate.getTime());
	    		}
	    			
	    		ct = home.findEvent(facilityIdList, priority, null, null, ftom, null, null, null, null, null, false, null);
	    	}
	    	catch(FinderException e){
	    	}
			return ct;
		} catch (NamingException e) {
		} catch (RemoteException e) {
		}
		m_ctx = null;
		return null;
	}
	
	/**
	 * ステータス情報 EnbtityBean のインスタンスを返します。<br>
	 * 
	 * @param facilityId ファシリティID
	 * @return ステータス情報 EnbtityBean
	 */
	public synchronized Collection getStatus(
			String facilityId) {
		try {
			m_ctx = LoginManager.getContextManager().getNamingContext(
					Config.getConfig("Login.USER"),
					Config.getConfig("Login.PASSWORD"), 
					Config.getConfig("Login.URL"));
		} catch (NamingException e) {
			return null;
		}

		Collection ct = null;
		try {
	    	try{
	    		StatusInfoHome home = (StatusInfoHome) m_ctx
                .lookup(StatusInfoHome.JNDI_NAME);
	    		
	    		String[] facilityIdList = {facilityId};
	    		ct = home.findStatus(facilityIdList, null, null, null, null, null, null, null);
	    	}
	    	catch(FinderException e){
	    	}
			return ct;
		} catch (NamingException e) {
		} catch (RemoteException e) {
		}
		m_ctx = null;
		return null;
	}
}