/*
 
Copyright (C) 2008 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.hinemos.test.logtransfer;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;

import jp.co.intellilink.hinemos.test.util.Config;
import jp.co.intellilink.hinemos.test.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.test.util.Messages;
import jp.co.intellilink.hinemos.test.util.StringListComparator;
import jp.co.intellilink.hinemos.test.util.WriteCsvFile;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.logtransfer.bean.LogTransferFileInfo;
import com.clustercontrol.logtransfer.bean.LogTransferInfo;
import com.clustercontrol.logtransfer.ejb.session.LogTransferController;
import com.clustercontrol.repository.ejb.session.RepositoryController;

/**
 * ログ転送情報を基に試験項目のCSVフォーマット文字列を作成する。<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ExportTestCaseLogTransfer {
	
	// ログ出力
	private static Log log = LogFactory.getLog(ExportTestCaseLogTransfer.class);
	
    /**
     * ログ転送情報を基に試験項目のCSVフォーマット文字列を作成する。<br>
     */
    public void exportTestCase() {
    	log.info("[" + Messages.getMsg("ExportTestCase")+ "] " + Messages.getMsg("TestTool.LogTransfer.Start"));
    	
    	//CSV出力配列を用意
    	ArrayList<ArrayList<String>> csvOutput = new ArrayList<ArrayList<String>>();
    	
    	//通知IDリスト取得
    	ArrayList idList = getLogTransferIdList();
    	
    	if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				ArrayList line = (ArrayList)itr.next();
				
				Object[] args = {(String)line.get(0)};
				log.info("[" + Messages.getMsg("ExportTestCase")+ "] " + Messages.getMsg("TestTool.TransferID", args));
				
				LogTransferInfo info = getLogTransfer((String)line.get(0));
				csvOutput.addAll(createTestCase(info));
			}
			
			//ファイルパスでソート
			Collections.sort(csvOutput, new StringListComparator(2));
			//ファシリティIDでソート
			Collections.sort(csvOutput, new StringListComparator(1));
			//転送IDでソート
			Collections.sort(csvOutput, new StringListComparator(0));
    	}
    	
		SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HHmmss");
		
		WriteCsvFile.writeCsvFile(
				Config.getConfig("Testcase.Output.Dir") + "/LOGTRANSFER_" + format.format(new Date()) + ".csv", 
				csvOutput);
		
		log.info("[" + Messages.getMsg("ExportTestCase")+ "] " + Messages.getMsg("TestTool.LogTransfer.End"));
    }
    
	/**
	 * ログ転送情報を基に試験項目のCSVフォーマット文字列を作成する。<br>
	 * 
	 * @param transferInfo 転送情報
	 * @return CSVフォーマット文字列
	 */
	public ArrayList<ArrayList<String>> createTestCase(LogTransferInfo transferInfo) {
		ArrayList<ArrayList<String>> csvFormat = new ArrayList<ArrayList<String>>();
		ArrayList<String> facilityIdList = new ArrayList<String>();
		
        //監視結果のファシリティIDリストを取得
		facilityIdList.addAll(getNodeList(transferInfo.getFacilityId()));
		
		for(String facilityId : facilityIdList){
			for(LogTransferFileInfo fileInfo : transferInfo.getFileInfo()){
				ArrayList<String> csvLine = new ArrayList<String>();
				//転送ID
				csvLine.add(transferInfo.getTransferId());
				//ファシリティID
				csvLine.add(facilityId);
				//ファイルパス
				csvLine.add(fileInfo.getFilePath());
				
				//イベントチェック（重要度別）
				csvLine.addAll(checkEvent(transferInfo, facilityId, fileInfo));
				
				csvFormat.add(csvLine);

				break;
			}

		}
		
		return csvFormat;
	}
	
	/**
     * イベント出力結果をチェックする。<br>
     * 
	 * @param transferInfo 転送情報
	 * @param facilityId ファシリティID
	 * @param fileInfo 転送ファイル情報
	 * @return CSVフォーマット文字列
	 */
	protected ArrayList<String> checkEvent(LogTransferInfo transferInfo, 
			String facilityId, LogTransferFileInfo fileInfo) {
		ArrayList<String> csvFormat = new ArrayList<String>();

		String info = "-";
		String warning = "-";
		String critical = "-";
		String unknown = "-";
		
		//監視が無効の場合
		if(transferInfo.getValid() == YesNoConstant.TYPE_YES && 
				fileInfo.getValid() == YesNoConstant.TYPE_YES){
			info = "";
			warning = "";
			critical = "";
			unknown = "";
		}
		
		csvFormat.add(info);
		csvFormat.add(warning);
		csvFormat.add(critical);
		csvFormat.add(unknown);
		
		return csvFormat;
	}

	/**
	 * ノードのファシリティIDを取得する。<br>
	 */
    protected ArrayList<String> getNodeList(String facilityId) {

		RepositoryController repository = EjbConnectionManager.getConnectionManager().getRepositoryController();

		ArrayList<String> records = new ArrayList<String>();
		try {
			if(repository.isNode(facilityId)){
				records.add(facilityId);
			}
			else{
				records.addAll(repository.getExecTargetFacilityIdList(facilityId));
			}
		} catch (Exception e) {
			log.error("[" + Messages.getMsg("ExportTestCase")+ "] " + Messages.getMsg("TestTool.ConnectManagerFailed"), e);
			System.exit(14);
		}
		return records;
	}
	
    /**
     * ログ転送情報を取得する。<br>
     * 
     * @param transferId 取得対象の転送ID
     * @return ログ転送情報
     */
    protected LogTransferInfo getLogTransfer(String transferId) {

    	LogTransferController transfer = EjbConnectionManager.getConnectionManager().getLogTransferController();

    	LogTransferInfo info = null;
        try {
        	info = transfer.getLogTransfer(transferId);
        } catch (Exception e) {
			log.error("[" + Messages.getMsg("ExportTestCase")+ "] " + Messages.getMsg("TestTool.ConnectManagerFailed"), e);
			System.exit(14);
        }
        return info;
    }
    
    /**
     * 転送IDリストを取得する。<br>
     * 
     * @return 転送ID一覧
     */
    protected ArrayList getLogTransferIdList() {

    	LogTransferController transfer = EjbConnectionManager.getConnectionManager().getLogTransferController();

        ArrayList records = null;
        try {
            records = transfer.getLogTransferList();
        } catch (Exception e) {
			log.error("[" + Messages.getMsg("ExportTestCase")+ "] " + Messages.getMsg("TestTool.ConnectManagerFailed"), e);
			System.exit(14);
        }
        return records;
    }
}