<?php
	// Copyright (c) 2008, u6k.yu1@gmail.com
	// All rights reserved.
	// 
	// Redistribution and use in source and binary forms, with or without
	// modification, are permitted provided that the following conditions are met:
	//     * Redistributions of source code must retain the above copyright
	//       notice, this list of conditions and the following disclaimer.
	//     * Redistributions in binary form must reproduce the above copyright
	//       notice, this list of conditions and the following disclaimer in the
	//       documentation and/or other materials provided with the distribution.
	//     * Neither the name of the u6k nor the
	//       names of its contributors may be used to endorse or promote products
	//       derived from this software without specific prior written permission.
	// 
	// THIS SOFTWARE IS PROVIDED BY u6k.yu1@gmail.com ``AS IS'' AND ANY
	// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
	// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
	// DISCLAIMED. IN NO EVENT SHALL u6k.yu1@gmail.com BE LIABLE FOR ANY
	// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
	// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
	// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
	// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
	// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
	
	/**
	 * ひらめきノートで使用する例外クラスの定義、及びエラー・ハンドラを定義します。
	 * 
	 * ひらめきノートでは、PHPにしろPEARにしろ、エラーが発生した場合、エラー・ハンドラによって例外がスローされます。
	 * 
	 * @package common
	 * @author u6k <u6k.yu1@gmail.com>
	 * @copyright Copyright (c) 2008 u6k.yu1@gmail.com, All rights reserved.
	 * @license BSD License
	 * @version $Id$
	 * @link http://hirameki-note.sourceforge.jp/ ひらめきノート
	 */
	
	require_once("PEAR.php");
	
	error_reporting(E_ALL);
	
	/**
	 * PEARで発生したエラーを表す例外です。
	 * 
	 * ひらめきノートでは、PEARでエラーが発生すると、エラー・ハンドラで{@link PEARException}例外がスローされます。
	 * 
	 * @package common
	 * @author u6k <u6k.yu1@gmail.com>
	 * @copyright Copyright (c) 2008 u6k.yu1@gmail.com, All rights reserved.
	 * @license BSD License
	 * @version $Id$
	 * @link http://hirameki-note.sourceforge.jp/ ひらめきノート
	 */
	class PEARException extends Exception {
	}
	
	/**
	 * PHPで発生したエラーを表す例外です。
	 * 
	 * ひらめきノートでは、PHPでエラーが発生すると、エラー・ハンドラで{@link PHPException}例外がスローされます。
	 * 
	 * @package common
	 * @author u6k <u6k.yu1@gmail.com>
	 * @copyright Copyright (c) 2008 u6k.yu1@gmail.com, All rights reserved.
	 * @license BSD License
	 * @version $Id$
	 * @link http://hirameki-note.sourceforge.jp/ ひらめきノート
	 */
	class PHPException extends Exception {
	}
	
	/**
	 * 関数、メソッドの呼び出しにおける引数に関連する例外を表します。
	 * 
	 * 例えば、引数が無指定、空、型が違う、配列の範囲を超えている、などのときにエラー・ハンドラで{@link PHPException}例外がスローされます。
	 * 
	 * @package common
	 * @author u6k <u6k.yu1@gmail.com>
	 * @copyright Copyright (c) 2008 u6k.yu1@gmail.com, All rights reserved.
	 * @license BSD License
	 * @version $Id$
	 * @link http://hirameki-note.sourceforge.jp/ ひらめきノート
	 */
	class ArgumentException extends Exception {
	}
	
	/**
	 * データベース操作に関連する例外を表します。
	 * 
	 * @package common
	 * @author u6k <u6k.yu1@gmail.com>
	 * @copyright Copyright (c) 2008 u6k.yu1@gmail.com, All rights reserved.
	 * @license BSD License
	 * @version $Id$
	 * @link http://hirameki-note.sourceforge.jp/ ひらめきノート
	 */
	class SQLException extends Exception {
	}
	
	/**
	 * ひらめきノートの業務処理に関連する例外を表します。
	 * 
	 * @package common
	 * @author u6k <u6k.yu1@gmail.com>
	 * @copyright Copyright (c) 2008 u6k.yu1@gmail.com, All rights reserved.
	 * @license BSD License
	 * @version $Id$
	 * @link http://hirameki-note.sourceforge.jp/ ひらめきノート
	 */
	class HiramekiException extends Exception {
	}
	
	/**
	 * PHPで発生したエラーを{@link PHPException}例外としてスローします。
	 * 
	 * @package common
	 * @author u6k <u6k.yu1@gmail.com>
	 * @copyright Copyright (c) 2008 u6k.yu1@gmail.com, All rights reserved.
	 * @license BSD License
	 * @version $Id$
	 * @link http://hirameki-note.sourceforge.jp/ ひらめきノート
	 * 
	 * @param integer $errno エラー番号。
	 * @param integer $errstr エラー・メッセージ。
	 * @return void
	 */
	function hirameki_php_error_handler($errno, $errstr) {
		throw new PHPException($errstr, $errno);
	}
	set_error_handler("hirameki_php_error_handler", E_ALL);
	
	/**
	 * PEARで発生したエラーを{@link PEARException}例外としてスローします。
	 * 
	 * @package common
	 * @author u6k <u6k.yu1@gmail.com>
	 * @copyright Copyright (c) 2008 u6k.yu1@gmail.com, All rights reserved.
	 * @license BSD License
	 * @version $Id$
	 * @link http://hirameki-note.sourceforge.jp/ ひらめきノート
	 * 
	 * @param PEAR_Error $err PEAR_Errorインスタンス。
	 * @return void
	 */
	function hirameki_pear_error_handler($err) {
		throw new PEARException($err->getDebugInfo(), $err->getCode());
	}
	PEAR::setErrorHandling(PEAR_ERROR_CALLBACK, "hirameki_pear_error_handler");
?>
